/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import com.nokia.meego 1.0
import 'UIConstants.js' as UI

Item {
    id: helpDialog
    property string titleText: qsTr("Help")
    property string message

    signal clicked

    Rectangle {
        id: textRect
        anchors.fill: parent
        anchors.margins: UI.DEFAULT_MARGIN / 2
        color: "white"

        Text {
            id: helpTitle
            anchors.top: parent.top
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.topMargin: UI.DEFAULT_MARGIN / 2
            text: helpDialog.titleText
            font.pixelSize: UI.FONT_XLARGE
            font.bold: true
            horizontalAlignment: Text.AlignHCenter
        }

        Rectangle {
            id: border
            anchors.top: helpTitle.bottom
            anchors.bottom: closeButton.top
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.leftMargin: UI.DEFAULT_MARGIN / 2
            anchors.rightMargin: UI.DEFAULT_MARGIN / 2
            anchors.bottomMargin: UI.DEFAULT_MARGIN / 2
            radius: 3
            clip: true

            border.width: 1
            border.color: "lightgray"
            color: "transparent"

            Flickable {
                id: textFlickable
                anchors.fill: parent
                anchors.margins: UI.DEFAULT_MARGIN
                boundsBehavior: Flickable.StopAtBounds
                //            contentWidth: helpText.paintedWidth
                contentHeight: helpText.paintedHeight
                Text {
                    id: helpText
                    text: helpDialog.message
                    font.pixelSize: UI.FONT_DEFAULT
                    color: "black"
                    wrapMode: Text.WrapAtWordBoundaryOrAnywhere
                    width: parent.width
                    onLinkActivated: Qt.openUrlExternally(link)
                }
            }

            ScrollDecorator {
                flickableItem: textFlickable
            }

        }

        Button {
            id: closeButton
            text: qsTr("Close")
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.bottom: parent.bottom
            anchors.bottomMargin: UI.DEFAULT_MARGIN / 2
            onClicked: {
                helpDialog.visible = false
                helpDialog.clicked()
            }
        }

    }

    Rectangle {
        id: shadowRight
        color: "darkgray"
        anchors.left: textRect.right
        anchors.bottom: textRect.bottom
        width: UI.DEFAULT_MARGIN / 2
        height: textRect.height - UI.DEFAULT_MARGIN / 2
    }
    Rectangle {
        id: shadowBottom
        color: "darkgray"
        anchors.left: textRect.left
        anchors.leftMargin: UI.DEFAULT_MARGIN / 2
        anchors.top: textRect.bottom
        width:textRect.width
        height: UI.DEFAULT_MARGIN / 2
    }
}
