/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import com.nokia.meego 1.0
import 'UIConstants.js' as UI

Item {
    property variant fontconf
    property bool modified: (sansSerifCheck.checked !== fontconf.prefer("sans-serif")) ||
                            (serifCheck.checked !== fontconf.prefer("serif")) ||
                            (monospaceCheck.checked !== fontconf.prefer("monospace")) ||
                            (systemCheck.checked !== fontconf.prefer("Nokia Pure Text"))
//                            ||
//                            (embeddedBitmapCombo.selectedIndex !== fontconf.embeddedBitmap) ||
//                            (hintingCombo.selectedIndex !== fontconf.hinting)

    height: childrenRect.height

    onFontconfChanged: {
        load()
    }

    function load()
    {
        if (!fontconf)
            return;
        sansSerifCheck.checked = fontconf.prefer("sans-serif")
        serifCheck.checked = fontconf.prefer("serif")
        monospaceCheck.checked = fontconf.prefer("monospace")
        systemCheck.checked = fontconf.prefer("Nokia Pure Text")
//        embeddedBitmapCombo.selectedIndex = fontconf.embeddedBitmap
//        hintingCombo.selectedIndex = fontconf.hinting
    }

    function save()
    {
        if (!modified)
            return;
        if (!fontconf)
            return;
        if (sansSerifCheck.checked)
            fontconf.addPreferFamily("sans-serif")
        else
            fontconf.removePreferFamily("sans-serif")
        if (serifCheck.checked)
            fontconf.addPreferFamily("serif")
        else
            fontconf.removePreferFamily("serif")
        if (monospaceCheck.checked)
            fontconf.addPreferFamily("monospace")
        else
            fontconf.removePreferFamily("monospace")
        if (systemCheck.checked)
            fontconf.addPreferFamily("Nokia Pure Text")
        else
            fontconf.removePreferFamily("Nokia Pure Text")
//        fontconf.embeddedBitmap = embeddedBitmapCombo.selectedIndex
//        fontconf.hinting = hintingCombo.selectedIndex
    }

    Column {
        width: parent.width
        spacing: UI.DEFAULT_MARGIN
        CheckBox {
            id: sansSerifCheck
            width: parent.width
            text: qsTr("Use as Prefer Font for Sans-Serif")
        }
        CheckBox {
            id: serifCheck
            width: parent.width
            text: qsTr("Use as Prefer Font for Serif")
        }
        CheckBox {
            id: monospaceCheck
            width: parent.width
            text: qsTr("Use as Prefer Font for Monospace")
        }
        CheckBox {
            id: systemCheck
            width: parent.width
            text: qsTr("Use as Prefer Font for System")
        }
//        ConfigValueComboBox {
//            id: embeddedBitmapCombo
//            width: parent.width
//            comboLabel: qsTr("Use Embedded Bitmap")
//        }
//        ConfigValueComboBox {
//            id: hintingCombo
//            width: parent.width
//            comboLabel: qsTr("Use Hinting")
//        }
    }

}
