/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import com.nokia.meego 1.0
import 'UIConstants.js' as UI

Page {
    id: fontInstallPage
    tools: backToolBar

    property variant fontInfo

    signal saveProperties

    function installFont(checked)
    {
        if (!checked && controller.fontExists(fontInfo))
            openOverwriteFontDialog()
        else
            controller.installFont(fontInfo);
    }

    Component.onDestruction: {
        if (fontInfo) {
            fontInfo.destroy()
        }
    }

    PageHeader {
        id: pageHeader
        anchors.top: parent.top
        anchors.left: parent.left
        anchors.right: parent.right
        text: qsTr("Install Font")
    }

    Item {
        id: contents
        anchors.top: pageHeader.bottom
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.right: parent.right

        Flickable {
            id: view
            anchors.top: parent.top
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.bottom: bottomField.top
            anchors.topMargin: UI.DEFAULT_MARGIN / 2
            anchors.bottomMargin: UI.DEFAULT_MARGIN / 2
            anchors.leftMargin: UI.DEFAULT_MARGIN / 2
            anchors.rightMargin: UI.DEFAULT_MARGIN / 2
            clip: true


            contentHeight: contentColumn.height

            Column {
                id: contentColumn
                width: parent.width
                spacing: UI.DEFAULT_MARGIN

                Repeater {
                    width: parent.width
                    model: fontInfo.families

                    delegate: Item {
                        width: parent.width
                        height: itemColumn.height + UI.DEFAULT_MARGIN * 2
                        Rectangle {
                            width: parent.width - 1
                            height: parent.height - 1
                            border.width: 1
                            color: "transparent"
                            Column {
                                id: itemColumn
                                anchors.top: parent.top
                                anchors.left: parent.left
                                anchors.right: parent.right
                                //                        width: parent.width
                                anchors.margins: UI.DEFAULT_MARGIN
                                spacing: UI.DEFAULT_MARGIN
                                Label {
                                    width: parent.width
                                    text: qsTr("<b>Font Family</b>: %1").arg(modelData)
                                }
                                Label {
                                    width: parent.width
                                    text: qsTr("<b>Example</b>: ")
                                }
                                Label {
                                    width: parent.width - UI.DEFAULT_MARGIN * 2
                                    x: UI.DEFAULT_MARGIN
                                    text: qsTr("The quick brown fox jumps over the lazy dog")
                                    font.family: modelData
                                }
                                FontsConfProperties {
                                    id: fontProp
                                    width: parent.width
                                    fontconf: fontInfo.fontProperty(modelData)
                                    Connections {
                                        target: fontInstallPage
                                        onSaveProperties: {
                                            fontProp.save()
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

            }

        }

        ScrollDecorator {
            flickableItem: view
        }

        Item {
            id: bottomField
            anchors.bottom: parent.bottom
            anchors.left: parent.left
            anchors.right: parent.right
            height: installButton.height + UI.DEFAULT_MARGIN * 2

            Rectangle {
                id: bgrect
                anchors.fill: parent
                gradient: Gradient {
                    GradientStop { position: 0.0; color: Qt.lighter("#76221d") }
                    GradientStop { position: 1.0; color: Qt.lighter("#bd543d") }
                }
            }

            Button {
                id: installButton
                anchors.centerIn: parent
                text: qsTr("Install")
                onClicked: {
                    saveProperties()
                    if (!controller.fontDirExists)
                        openCreateFontDirDialog()
                    else
                        installFont(false)
                }
            }
        }
    }


    function openCreateFontDirDialog()
    {
        queryDialog.titleText = qsTr("Create it?")
        queryDialog.message = qsTr("Local fonts directory '%1' does not exists!  Create it now?").arg(controller.fontDir)
        queryDialog.acceptButtonText = qsTr("OK")
        queryDialog.rejectButtonText = qsTr("Cancel")
        queryDialog.accepted.connect(createFontDir)
        queryDialog.open()
    }

    function createFontDir()
    {
        queryDialog.accepted.disconnect(createFontDir)
        controller.createFontDir()
        installFont(false)
    }

    function openOverwriteFontDialog()
    {
        queryDialog.titleText = qsTr("Overwrite it?")
        queryDialog.message = qsTr("Local font '%1' already exists!  Overwrite it?").arg(fontInfo.fileName)
        queryDialog.acceptButtonText = qsTr("OK")
        queryDialog.rejectButtonText = qsTr("Cancel")
        queryDialog.accepted.connect(overwriteFont)
        queryDialog.open()
    }

    function overwriteFont()
    {
        queryDialog.accepted.disconnect(overwriteFont)
        installFont(true)
    }

    ToolBarLayout {
        id: backToolBar
        ToolIcon {
            platformIconId: "toolbar-back"
            onClicked: pageStack.pop()
        }
    }

}
