/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

import QtQuick 1.1
import com.nokia.meego 1.0
import com.nokia.extras 1.0
import 'UIConstants.js' as UI

Item {
    id: listItem

    signal clicked
    property bool pressed: false

    property bool isHeader: model.header

    property int titleSize: (model.header ? UI.FONT_XLARGE : UI.FONT_DEFAULT)
    property int titleWeight: Font.Bold
    property color titleColor: theme.inverted ? (model.header ? UI.COLOR_FOREGROUND : UI.COLOR_INVERTED_FOREGROUND) : (UI.COLOR_FOREGROUND)

    property int subtitleSize: UI.FONT_XSMALL
    property int subtitleWeight: Font.Light
    property color subtitleColor: theme.inverted ? UI.COLOR_SECONDARY_FOREGROUND : UI.COLOR_INVERTED_SECONDARY_FOREGROUND

    height: UI.LIST_ITEM_HEIGHT_SMALL
    width: parent.width

    Rectangle {
        anchors.fill: parent
        anchors.leftMargin: -UI.MARGIN_XLARGE
        anchors.rightMargin: -UI.MARGIN_XLARGE
        anchors.topMargin: 1
        anchors.bottomMargin: 1
        color: UI.COLOR_SELECT
        visible: listItem.isHeader
    }

    Row {
        anchors.fill: parent
        spacing: UI.DEFAULT_MARGIN

        Item { width: UI.DEFAULT_MARGIN; height: 1; visible: !model.header }

        Item {
            //                        anchors.top: parent.top
            height: UI.LIST_ITEM_HEIGHT_SMALL

            Column {
                anchors.verticalCenter: parent.verticalCenter

                Text {
                    id: mainText
                    text: model.title
                    font.weight: listItem.titleWeight
                    font.pixelSize: listItem.titleSize
                    color: listItem.titleColor
                }

                Text {
                    id: subText
                    text: model.subtitle
                    font.weight: listItem.subtitleWeight
                    font.pixelSize: listItem.subtitleSize
                    color: listItem.subtitleColor

                    visible: text != ""
                }
            }
        }
    }

    ListButton {
        id: appendButton
        anchors.right: parent.right
        anchors.verticalCenter: parent.verticalCenter
        anchors.rightMargin: UI.DEFAULT_MARGIN
        iconSource: "image://theme/icon-m-toolbar-add"
        onClicked: {
            openSelectInstallFamilyDialog(model.priority)
        }
        visible: listItem.isHeader
    }

    Loader {
        id: selectInstallFamilyDialogLoader
        anchors.fill: parent
    }

    MouseArea {
        id: selectItem
        anchors.fill: parent
        enabled: !listItem.isHeader
        visible: !listItem.isHeader
        onClicked: {
            if (preferFamilyListView.currentIndex === index)
                preferFamilyListView.currentIndex = -1
            else
                preferFamilyListView.currentIndex = index
        }
    }
}
