/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

import QtQuick 1.1
import com.nokia.meego 1.0
import 'UIConstants.js' as UI

Item {
    id: comboBox
    property int selectedIndex: 0
    property string comboLabel: value

//    width: parent.width
    height: Math.max(UI.LIST_ITEM_HEIGHT_SMALL, labelColumn.height)

    function valueLabel(index)
    {
        return qsTr(configValueModel.get(index).name)
    }

    Column {
        id: labelColumn
        anchors.left: parent.left
        width: parent.width - comboIcon.width
        Label {
            id: titlelabel
            text: comboLabel
            font.bold: true
            font.family: UI.FONT_DEFAULT
        }
        Label {
            id: valuelabel
            text: valueLabel(selectedIndex)
            font.bold: false
            font.family: UI.FONT_LSMALL
            color: UI.COLOR_SECONDARY_FOREGROUND
        }
    }
    Image {
        id: comboIcon
        anchors.verticalCenter: parent.verticalCenter
        anchors.right: parent.right
        source: "image://theme/meegotouch-combobox-indicator" +
                (mouseArea.pressed ? "-pressed" : "")
    }
    MouseArea {
        id: mouseArea
        anchors.fill: parent
        onClicked: selectionDialog.open()
    }

    ListModel {
        id: configValueModel
        ListElement { name: QT_TR_NOOP("Default") }
        ListElement { name: QT_TR_NOOP("Yes") }
        ListElement { name: QT_TR_NOOP("No") }
    }

    SelectionDialog {
        id: selectionDialog
        model: configValueModel
        titleText: comboLabel
        selectedIndex: comboBox.selectedIndex
        onAccepted: {
            comboBox.selectedIndex = selectedIndex
        }
    }
}
