/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

import QtQuick 1.1
import com.nokia.meego 1.0
import 'UIConstants.js' as UI

Item {
    id: bottomButtons
    
    property Item targetTab

    height: bottomItem.height + importButton.height + UI.DEFAULT_MARGIN * 2

    Rectangle {
        anchors.fill: parent
        anchors.topMargin: UI.DEFAULT_MARGIN / 2
        gradient: Gradient {
            GradientStop { position: 0.0; color: Qt.lighter("#76221d") }
            GradientStop { position: 1.0; color: Qt.lighter("#bd543d") }
        }
    }
    
    Item {
        id: bottomItem
        anchors.bottom: importButton.top
        anchors.left: parent.left
        anchors.right: parent.right
        height: UI.LIST_ITEM_HEIGHT_SMALL
        
        Button {
            width: 75
            anchors.left: parent.left
            anchors.leftMargin: UI.DEFAULT_MARGIN
            iconSource: "image://theme/icon-m-toolbar-down"
            onClicked: targetTab.moveDownFamily()
            enabled: targetTab !== null &&
                     (targetTab.listView.currentIndex >= 0 &&
                      targetTab.listView.currentIndex < targetTab.listView.count - 1) &&
                     (!targetTab.listView.model.get(targetTab.listView.currentIndex+1).header)
        }
        
        Button {
            width: 75
            anchors.horizontalCenter: parent.horizontalCenter
            iconSource: "image://theme/icon-m-toolbar-delete"
            onClicked: targetTab.removeFamily()
            enabled: targetTab !== null && targetTab.listView.currentIndex >= 0
        }
        
        Button {
            width: 75
            anchors.right: parent.right
            anchors.rightMargin: UI.DEFAULT_MARGIN
            iconSource: "image://theme/icon-m-toolbar-up"
            onClicked: targetTab.moveUpFamily()
            enabled: targetTab !== null && (targetTab.listView.currentIndex > 0) && (!targetTab.listView.model.get(targetTab.listView.currentIndex-1).header)
        }
    }
    
    Button {
        id: importButton
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.bottom: parent.bottom
        anchors.bottomMargin: UI.DEFAULT_MARGIN
        text: qsTr("Import System Settings")
        opacity: 0.9
        onClicked: {
            controller.importSystemSettings(targetTab.family)
        }
        enabled: targetTab !== null
    }
}
