/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

#include <QtGui/QApplication>
#include "qmlapplicationviewer.h"
#include "applicationcontroller.h"

#include <qdeclarative.h>
#include <QDeclarativeContext>

#include <QDir>
#include <QLocale>
#include <QTranslator>

#include "fontinfo.h"
#include "installedfontinfo.h"
#include "fontsconfigproperties.h"
#include "fontsconfeditorcontroller.h"

Q_DECL_EXPORT int main(int argc, char *argv[])
{
    QScopedPointer<QApplication> app(createApplication(argc, argv));

    QTranslator translator;
    QString i18nDir = QDir::cleanPath(app->applicationDirPath() + "/../i18n");
    bool check = translator.load(QLatin1String("fontmanager_") + QLocale::system().name(), i18nDir);
    if (check)
        app->installTranslator(&translator);

    ApplicationController appController;

#if 0
    qmlRegisterUncreatableType<FontsConfigProperties>("FontConfig", 1, 0, "FontsConfigProperties", "Error");
    qmlRegisterUncreatableType<FontInfo>("FontConfig", 1, 0, "FontInfo", "Error");
    qmlRegisterUncreatableType<InstalledFontInfo>("FontConfig", 1, 0, "InstalledFontInfo", "Error");
    qmlRegisterUncreatableType<FontsConfEditorController>("FontConfig", 1, 0, "FontsConfEditorController", "Error");
#else
    qmlRegisterType<FontsConfigProperties>();
    qmlRegisterType<FontInfo>();
    qmlRegisterType<InstalledFontInfo>();
    qmlRegisterType<FontsConfEditorController>();
#endif

    QmlApplicationViewer viewer;
    viewer.rootContext()->setContextProperty("controller", &appController);
    viewer.setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
    viewer.setMainQmlFile(QLatin1String("qml/fontmanager/main.qml"));
    viewer.showExpanded();

    appController.init();

    return app->exec();
}
