/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

#ifndef INSTALLEDFONTINFO_H
#define INSTALLEDFONTINFO_H

#include <QObject>
#include <QStringList>

class FontsConfigProperties;

class InstalledFontInfo : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QStringList family READ family NOTIFY detailsChanged)
    Q_PROPERTY(QStringList familylang READ familylang NOTIFY detailsChanged)
    Q_PROPERTY(QStringList style READ style NOTIFY detailsChanged)
    Q_PROPERTY(QStringList stylelang READ stylelang NOTIFY detailsChanged)
    Q_PROPERTY(QStringList fullname READ fullname NOTIFY detailsChanged)
    Q_PROPERTY(QStringList fullnamelang READ fullnamelang NOTIFY detailsChanged)

    Q_PROPERTY(QString localefamily READ localefamily NOTIFY detailsChanged)
    Q_PROPERTY(QString localestyle READ localestyle NOTIFY detailsChanged)
    Q_PROPERTY(QString localefullname READ localefullname NOTIFY detailsChanged)

    Q_PROPERTY(QString enfamily READ enfamily NOTIFY detailsChanged)
    Q_PROPERTY(QString enstyle READ enstyle NOTIFY detailsChanged)
    Q_PROPERTY(QString enfullname READ enfullname NOTIFY detailsChanged)

    Q_PROPERTY(QString foundry READ foundry NOTIFY detailsChanged)
    Q_PROPERTY(QString file READ file NOTIFY detailsChanged)
    Q_PROPERTY(QStringList lang READ lang NOTIFY detailsChanged)
    Q_PROPERTY(bool outline READ outline NOTIFY detailsChanged)
    Q_PROPERTY(bool scalable READ scalable NOTIFY detailsChanged)
    Q_PROPERTY(int slant READ slant NOTIFY detailsChanged)
    Q_PROPERTY(int weight READ weight NOTIFY detailsChanged)
    Q_PROPERTY(int width READ width NOTIFY detailsChanged)

    Q_PROPERTY(bool systemFont READ systemFont NOTIFY detailsChanged)

public:
    explicit InstalledFontInfo(const QByteArray buf, const QString &localFontPath, QObject *parent = 0);
    
    bool isValid();

    QStringList family() const;
    QStringList familylang() const;
    QStringList style() const;
    QStringList stylelang() const;
    QStringList fullname() const;
    QStringList fullnamelang() const;
    QString foundry() const;
    QString file() const;
    QStringList lang() const;
    bool outline() const;
    bool scalable() const;
    int slant() const;
    int weight() const;
    int width() const;

    QString localefamily() const;
    QString localestyle() const;
    QString localefullname() const;

    QString enfamily() const;
    QString enstyle() const;
    QString enfullname() const;

    QString locale() const;
    void setLocale(const QString &loc);

    bool systemFont() const;

    QString localeString(const QStringList &strlist, const QStringList &langlist, const QString &lang) const;

    Q_INVOKABLE FontsConfigProperties *fontProperty() const;
    void setFontProperty(FontsConfigProperties *prop);

    static bool compare(const InstalledFontInfo *info1, InstalledFontInfo *info2);

signals:
    void detailsChanged();

public slots:

private:
    bool analyze(const QByteArray &buf, const QString &localFontPath);

    static QString toString(const QString &value);
    static QStringList toStringList(const QString &value);
    static int toInt(const QString &value);
    static bool toBool(const QString &value);

private:
    bool mValid;

    QStringList mFamily;
    QStringList mFamilylang;
    QStringList mStyle;
    QStringList mStylelang;
    QStringList mFullname;
    QStringList mFullnamelang;
    QString mFoundry;
    QString mFile;
    QStringList mLang;
    bool mOutline;
    bool mScalable;
    int mSlant;
    int mWeight;
    int mWidth;

    bool mSystemFont;

    QString mLocale;

    FontsConfigProperties *mFontProperty;
};

#endif // INSTALLEDFONTINFO_H
