/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

#ifndef FONTSCONFIGPROPERTIES_H
#define FONTSCONFIGPROPERTIES_H

#include <QObject>
#include <QStringList>
#include <QMap>

class FontsConfigProperties : public QObject
{
    Q_OBJECT
    Q_ENUMS(ConfigValue)
    Q_PROPERTY(QString family READ family)
    Q_PROPERTY(QStringList preferFamilies READ preferFamilies NOTIFY preferFamiliesChanged)
    Q_PROPERTY(ConfigValue embeddedBitmap READ embeddedBitmap WRITE setEmbeddedBitmap NOTIFY embeddedBitmapChanged)
    Q_PROPERTY(ConfigValue hinting READ hinting WRITE setHinting NOTIFY hintingChanged)
    Q_PROPERTY(ConfigValue antialias READ antialias WRITE setAntialias NOTIFY antialiasChanged)
    Q_PROPERTY(ConfigValue autohint READ autohint WRITE setAutohint NOTIFY autohintChanged)
public:
    explicit FontsConfigProperties(const QString &family, QObject *parent = 0);
    
    enum ConfigValue { Default, True, False };

    QString family() const;

    QStringList preferFamilies() const;
public slots:
    void addPreferFamily(const QString &family);
    void removePreferFamily(const QString &family);
public:
    Q_INVOKABLE bool prefer(const QString &family) const;

    ConfigValue configValue(const QString &key) const;
    void setConfigValue(const QString &key, ConfigValue config);

    ConfigValue embeddedBitmap() const;
    void setEmbeddedBitmap(ConfigValue config);

    ConfigValue hinting() const;
    void setHinting(ConfigValue config);

    ConfigValue antialias() const;
    void setAntialias(ConfigValue config);

    ConfigValue autohint() const;
    void setAutohint(ConfigValue config);

signals:
    void preferFamiliesChanged();

    void configValueChanged(const QString &key);

    void embeddedBitmapChanged();
    void hintingChanged();
    void antialiasChanged();
    void autohintChanged();

public slots:

private slots:
    void checkConfigValueChanged(const QString &key);

private:
    QString mFamily;
    QStringList mPreferFamilies;
    QMap<QString, ConfigValue> mConfigValues;
    ConfigValue mEmbeddedBitmap;
    ConfigValue mHinting;
};

#endif // FONTSCONFIGPROPERTIES_H
