/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

#ifndef FONTSCONFELEMENT_H
#define FONTSCONFELEMENT_H

#include <QObject>

#include <QVariant>
#include <QSharedPointer>

#include <QXmlStreamAttributes>
#include <QList>

class QXmlStreamReader;
class QXmlStreamWriter;

class FontsConfElement;

typedef QSharedPointer<FontsConfElement> FontsConfElementPointer;
typedef QList<FontsConfElementPointer> FontsConfElementList;

class FontsConfElement : public QObject
{
    Q_OBJECT
    Q_ENUMS(Type)
    Q_PROPERTY(QString type READ type NOTIFY typeChanged)
public:

    explicit FontsConfElement(const QString &type, QObject *parent = 0);
    
    QString type() const;

    virtual void clear();
    virtual bool parse(QXmlStreamReader &xml);
    virtual void save(QXmlStreamWriter &xml);

    QXmlStreamAttributes attributes() const;
    bool hasAttribute(const QString &key) const;
    QString value(const QString &key) const;
    void setAttribute(const QString &key, const QString &val);

    int count() const;
    FontsConfElementPointer childElementAt(int index) const;
    FontsConfElementList findChildrenElements(const QString &type) const;
    int indexOf(const QString &type, int from = 0) const;
    FontsConfElementPointer childElementOf(const QString &type, int from = 0) const;
    void addChildElement(FontsConfElementPointer elem);
    void insertChildElement(FontsConfElementPointer elem, int index);
    void removeAt(int index);
    void removeOne(FontsConfElementPointer elem);

    QString text() const;
    void setText(const QString &str);

    static QString readAttribute(QXmlStreamReader &xml, const QString &attr, const QString &defaultValue = QString());
    static QVariant readValue(QXmlStreamReader &xml);

signals:
    void typeChanged();
    
public slots:
    
protected:
    bool mModified;
    QString mType;
    QXmlStreamAttributes mAttributes;
    FontsConfElementList mChildElements;
    QString mText;
};

#endif // FONTSCONFELEMENT_H
