/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

#ifndef FONTSCONFEDITORCONTROLLER_H
#define FONTSCONFEDITORCONTROLLER_H

#include <QObject>
#include <QStringList>
#include <QMap>

class InstalledFontInfo;

class FontsConfEditorController : public QObject
{
    Q_OBJECT
    Q_PROPERTY(int count READ count NOTIFY countChanged)
public:
    explicit FontsConfEditorController(const QString &family, QObject *parent = 0);
    
    int count() const;

    int countOfFamily(const QString &priority) const;
    int indexOfFamily(const QString &family, const QString &priority) const;

signals:
    void clearFamilyList();
    void startSection(const QString &section, const QString &sectionName);
    void appendFamilyToList(const QString &section, const QString &family, const QString &priority, bool systemFont);
    void removeFamilyFromList(const QString &section, const QString &family, const QString &priority);

    void countChanged();

    void appendFamilyToConfig(const QString &family, const QString &value, const QString &priority);
    void insertFamilyToConfig(const QString &family, const QString &value, const QString &priority, int index);

public slots:
    void clear();
    void syncFamilyList();

    void appendFontsInfo(const QString &family, const QString &priority, InstalledFontInfo *info);
    void appendFamily(const QString &family, const QString &priority);
    void removeFamily(const QString &family, const QString &priority);

    void insertFamily(const QString &family, const QString &priority, int index);
    void moveFamilyUp(const QString &family, const QString &priority);
    void moveFamilyDown(const QString &family, const QString &priority);

private:
    bool mFromApp;
    QString mFamily;

    QStringList mPrependFamily;
    QStringList mPreferFamily;
    QStringList mAcceptFamily;
    QMap<QString, InstalledFontInfo*> mFontInfoMap;
};

#endif // FONTSCONFEDITORCONTROLLER_H
