/****************************************************************************
**
** Copyright (C) 2012 Takumi Asaki
** All rights reserved.
** Contact: Takumi Asaki (takumi.asaki@gmail.com)
**
** This file is part of the fontmanager application.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/

#ifndef FONTSCONF_H
#define FONTSCONF_H

#include <QObject>
#include <QStringList>

#include "fontsconfelement.h"

class FontsConf : public QObject
{
    Q_OBJECT
public:
    explicit FontsConf(QObject *parent = 0);

    bool isEmpty() const;
    bool modified() const;
    void setModified(bool value);
    bool hasUnknownConfig() const;

    bool isValid() const;

    void initFontsConf();

    bool parse(const QByteArray &buf);

    QStringList preferFamily() const;

    QStringList aliasFamilyFor(const QString &family, const QString &mode) const;
    int indxOfAliasFamilyFor(const QString &family, const QString &mode, const QString &value) const;
    void appendAliasFamilyFor(const QString &family, const QString &mode, const QString &value);
    void insertAliasFamilyFor(const QString &family, const QString &mode, const QString &value, int index);
    void removeAliasFamilyFor(const QString &family, const QString &mode, const QString &value);

    QStringList preferFamilyFor(const QString &family) const;
    int indxOfPreferFamilyFor(const QString &family, const QString &value) const;
    void appendPreferFamilyFor(const QString &family, const QString &value);
    void insertPreferFamilyFor(const QString &family, const QString &value, int index);
    void removePreferFamilyFor(const QString &family, const QString &value);

    QStringList acceptFamilyFor(const QString &family) const;
    int indxOfAcceptFamilyFor(const QString &family, const QString &value) const;
    void appendAcceptFamilyFor(const QString &family, const QString &value);
    void insertAcceptFamilyFor(const QString &family, const QString &value, int index);
    void removeAcceptFamilyFor(const QString &family, const QString &value);

    QStringList matchFamilyFor(const QString &config, bool val) const;
    QString matchEditValueFor(const QString &config, const QString &family) const;
    void setMatchEditValueFor(const QString &config, const QString &family, bool val);
    void unsetMatchEditValueFor(const QString &config, const QString &family);

    QStringList patternFamilyFor(const QString &family, const QString &mode) const;
    int indxOfPatternFamilyFor(const QString &family, const QString &mode, const QString &value) const;
    void appendPatternFamilyFor(const QString &family, const QString &mode, const QString &value);
    void insertPatternFamilyFor(const QString &family, const QString &mode, const QString &value, int index);
    void removePatternFamilyFor(const QString &family, const QString &mode, const QString &value);

    QStringList prependFamilyFor(const QString &family) const;
    int indxOfPrependFamilyFor(const QString &family, const QString &value) const;
    void appendPrependFamilyFor(const QString &family, const QString &value);
    void insertPrependFamilyFor(const QString &family, const QString &value, int index);
    void removePrependFamilyFor(const QString &family, const QString &value);

    QStringList appendFamilyFor(const QString &family) const;
    int indxOfAppendFamilyFor(const QString &family, const QString &value) const;
    void appendAppendFamilyFor(const QString &family, const QString &value);
    void insertAppendFamilyFor(const QString &family, const QString &value, int index);
    void removeAppendFamilyFor(const QString &family, const QString &value);

    void copy(FontsConf *src);

    static QStringList genericFamilies();
    static QStringList configKeys();

private:
    FontsConfElementPointer aliasElementFor(const QString &family) const;
    FontsConfElementPointer matchElementFor(const QString &config, bool val) const;
    FontsConfElementPointer patternElementFor(const QString &family) const;

    bool appendFamilyToAlias(FontsConfElementPointer aliasElem, const QString &family, const QString &mode, const QString &value);
    bool insertFamilyToAlias(FontsConfElementPointer aliasElem, const QString &family, const QString &mode, const QString &value, int index);
    bool isMatchElementFor(FontsConfElementPointer matchElem, const QString &config, const QString &family, const QString &val = QString()) const;
    bool isPatternElementFor(FontsConfElementPointer matchElem, const QString &family, const QString &mode = QString()) const;
    FontsConfElementPointer getEditPatternElementFor(FontsConfElementPointer matchElem, const QString &family, const QString &mode = QString()) const;

    bool containsTextElement(FontsConfElementPointer elem, const QString &tag, const QString &text) const;
    QStringList textElementList(FontsConfElementPointer elem, const QString &tag) const;

signals:
    
public slots:
    void load(const QString &path);
    void save(const QString &path);
    
private:
    bool mModified;
    bool mValid;
    bool mHasUnknownConfig;
    FontsConfElementPointer mElements;
};

#endif // FONTSCONF_H
