# Add more folders to ship with the application, here
folder_01.source = qml/fontmanager
folder_01.target = qml
DEPLOYMENTFOLDERS = folder_01

# Additional import path used to resolve QML modules in Creator's code model
QML_IMPORT_PATH =

symbian:TARGET.UID3 = 0xE6A64536

# Smart Installer package's UID
# This UID is from the protected range and therefore the package will
# fail to install if self-signed. By default qmake uses the unprotected
# range value if unprotected UID is defined for the application and
# 0x2002CCCF value if protected UID is given to the application
#symbian:DEPLOYMENT.installer_header = 0x2002CCCF

# Allow network access on Symbian
#symbian:TARGET.CAPABILITY += NetworkServices

# If your application uses the Qt Mobility libraries, uncomment the following
# lines and add the respective components to the MOBILITY variable.
# CONFIG += mobility
# MOBILITY +=

# Speed up launching on MeeGo/Harmattan when using applauncherd daemon
# CONFIG += qdeclarative-boostable

# Add dependency to Symbian components
# CONFIG += qt-components

defineReplace(cleanPath) {
    win32:1 ~= s|\\\\|/|g
    contains(1, ^/.*):pfx = /
    else:pfx =
    segs = $$split(1, /)
    out =
    for(seg, segs) {
        equals(seg, ..):out = $$member(out, 0, -2)
        else:!equals(seg, .):out += $$seg
    }
    return($$join(out, /, $$pfx))
}

SOURCE_TREE_ROOT = $$PWD
isEmpty(BUILD_TREE_ROOT) {
    sub_dir = $$_PRO_FILE_PWD_
    sub_dir ~= s,^$$re_escape($$PWD),,
    BUILD_TREE_ROOT = $$cleanPath($$OUT_PWD)
    BUILD_TREE_ROOT ~= s,$$re_escape($$sub_dir)$,,
}

# The .cpp file which was generated for your project. Feel free to hack it.
SOURCES += main.cpp \
    applicationcontroller.cpp \
    fontinfo.cpp \
    fontconfigmanager.cpp \
    installedfontinfo.cpp \
    fontsconfigproperties.cpp \
    fontsconfelement.cpp \
    fontsconf.cpp \
    fontsconfeditorcontroller.cpp

# Please do not modify the following two lines. Required for deployment.
include(qmlapplicationviewer/qmlapplicationviewer.pri)
qtcAddDeployment()

OTHER_FILES += \
    qtc_packaging/debian_harmattan/rules \
    qtc_packaging/debian_harmattan/README \
    qtc_packaging/debian_harmattan/manifest.aegis \
    qtc_packaging/debian_harmattan/copyright \
    qtc_packaging/debian_harmattan/control \
    qtc_packaging/debian_harmattan/compat \
    qtc_packaging/debian_harmattan/changelog \
    qtc_packaging/debian_harmattan/README_ja.txt

HEADERS += \
    applicationcontroller.h \
    fontinfo.h \
    fontconfigmanager.h \
    installedfontinfo.h \
    fontsconfigproperties.h \
    fontconfigdefs.h \
    fontsconfelement.h \
    fontsconf.h \
    fontsconfeditorcontroller.h

include(translations/translations.pri)

