package net.tk_factory.sample.jfreechart;

import java.io.FileOutputStream;
import java.io.IOException;

import net.tk_factory.sample.AbstractSample;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.data.time.Month;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

/**
 * JFreeChartѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>󥰥դޤ</li>
 * <li>ChartUtilities饹ѤơPNGǲϤޤ</li>
 * </ol>
 *
 * @author Takafumi Kondo (TK Factory)
 *
 * @see org.jfree.chart.ChartFactory#createTimeSeriesChart
 * @see org.jfree.chart.StandardChartTheme#createLegacyTheme
 */
public class SampleCreateTimeSeriesChart extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleCreateTimeSeriesChart.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleCreateTimeSeriesChart.class.getName());

    /** ϥե̾PNG */
    private static final String OUT_FILE_NAME_PNG =
        SAMPLE_FILE_DIRECTORY +  CLASS_NAME + ".png";

    /**
     * SampleCreateTimeSeriesChart֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleCreateTimeSeriesChart()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream png = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME_PNG);

            //쥬ơޤꤹ
            ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());

            Month[] month =
            {
                    new Month(1, 2009),
                    new Month(2, 2009),
                    new Month(3, 2009),
                    new Month(4, 2009),
                    new Month(5, 2009),
                    new Month(6, 2009),
                    new Month(7, 2009),
            };

            //󥰥դΥǡå
            TimeSeriesCollection dataset = new TimeSeriesCollection();
            //
            TimeSeries series1 = new TimeSeries("", Month.class);
            series1.add(month[0], 22.8);
            series1.add(month[1], 19.0);
            series1.add(month[2], 20.2);
            series1.add(month[3], 24.5);
            series1.add(month[4], 18.4);
            series1.add(month[5], 14.7);
            series1.add(month[6], 14.3);
            dataset.addSeries(series1);
            //20
            TimeSeries series2 = new TimeSeries("20", Month.class);
            series2.add(month[0], 20.3);
            series2.add(month[1], 14.1);
            series2.add(month[2], 12.4);
            series2.add(month[3], 19.8);
            series2.add(month[4], 15.7);
            series2.add(month[5], 9.1);
            series2.add(month[6], 10.7);
            dataset.addSeries(series2);
            //30
            TimeSeries series3 = new TimeSeries("30", Month.class);
            series3.add(month[0], 24.5);
            series3.add(month[1], 17.6);
            series3.add(month[2], 20.5);
            series3.add(month[3], 20.5);
            series3.add(month[4], 11.4);
            series3.add(month[5], 12.7);
            series3.add(month[6], 11.6);
            dataset.addSeries(series3);
            //40
            TimeSeries series4 = new TimeSeries("40", Month.class);
            series4.add(month[0], 19.5);
            series4.add(month[1], 15.8);
            series4.add(month[2], 15.9);
            series4.add(month[3], 23.4);
            series4.add(month[4], 15.8);
            series4.add(month[5], 12.0);
            series4.add(month[6], 15.1);
            dataset.addSeries(series4);
            //50
            TimeSeries series5 = new TimeSeries("50", Month.class);
            series5.add(month[0], 24.3);
            series5.add(month[1], 21.5);
            series5.add(month[2], 21.8);
            series5.add(month[3], 26.6);
            series5.add(month[4], 23.1);
            series5.add(month[5], 17.3);
            series5.add(month[6], 14.6);
            dataset.addSeries(series5);
            //60ʾ
            TimeSeries series6 = new TimeSeries("60ʾ", Month.class);
            series6.add(month[0], 27.2);
            series6.add(month[1], 31.8);
            series6.add(month[2], 35.2);
            series6.add(month[3], 41.6);
            series6.add(month[4], 36.3);
            series6.add(month[5], 29.3);
            series6.add(month[6], 24.6);
            dataset.addSeries(series6);

            //󥰥դ
            JFreeChart chart = ChartFactory.createTimeSeriesChart(
                    //եȥ
                    "ջٻΨ",
                    //ƥ꼴٥
                    "ǯ",
                    //ͼ٥
                    "ٻΨ",
                    //ǡå
                    dataset,
                    //Ƚɽ̵ͭ
                    true,
                    //ġåפɽ̵ͭ
                    false,
                    //URLưŪ̵ͭ
                    false);

            //PNGǥե¸
            png = new FileOutputStream(OUT_FILE_NAME_PNG);
            ChartUtilities.writeChartAsPNG(png, chart, 600, 400);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (png != null)
                {
                    png.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
