package net.tk_factory.sample.jfreechart;

import java.io.FileOutputStream;
import java.io.IOException;

import net.tk_factory.sample.AbstractSample;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/**
 * JFreeChartѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>˺ɸդޤ</li>
 * <li>ChartUtilities饹ѤơPNGǲϤޤ</li>
 * </ol>
 *
 * @author Takafumi Kondo (TK Factory)
 *
 * @see org.jfree.chart.ChartFactory#createPolarChart
 * @see org.jfree.chart.StandardChartTheme#createLegacyTheme
 */
public class SampleCreatePolarChart extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleCreatePolarChart.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleCreatePolarChart.class.getName());

    /** ϥե̾PNG */
    private static final String OUT_FILE_NAME_PNG =
        SAMPLE_FILE_DIRECTORY +  CLASS_NAME + ".png";

    /**
     * SampleCreatePolarChart֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleCreatePolarChart()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream png = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME_PNG);

            //쥬ơޤꤹ
            ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());

            //˺ɸդΥǡꤹ
            XYSeriesCollection dataset = new XYSeriesCollection();
            //
            XYSeries series1 = new XYSeries("");
            series1.add(55, 30);
            series1.add(78, 70);
            series1.add(150, 25);
            series1.add(300, 12);
            series1.add(210, 60);
            dataset.addSeries(series1);
            //±
            XYSeries series2 = new XYSeries("±");
            series2.add(155, 50);
            series2.add(51, 20);
            series2.add(85, 65);
            series2.add(255, 75);
            series2.add(320, 50);
            dataset.addSeries(series2);

            //˺ɸդ
            JFreeChart chart = ChartFactory.createPolarChart(
                    //եȥ
                    "ǣУӱ",
                    //ǡå
                    dataset,
                    //Ƚɽ̵ͭ
                    true,
                    //ġåפɽ̵ͭ
                    false,
                    //URLưŪ̵ͭ
                    false);

            //PNGǥե¸
            png = new FileOutputStream(OUT_FILE_NAME_PNG);
            ChartUtilities.writeChartAsPNG(png, chart, 600, 400);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (png != null)
                {
                    png.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
