package net.tk_factory.sample.jfreechart;

import java.io.FileOutputStream;
import java.io.IOException;

import net.tk_factory.sample.AbstractSample;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.data.general.DefaultPieDataset;

/**
 * JFreeChartѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>ߥաʣġˤޤ</li>
 * <li>ChartUtilities饹ѤơPNGǲϤޤ</li>
 * </ol>
 *
 * @author Takafumi Kondo (TK Factory)
 *
 * @see org.jfree.chart.ChartFactory#createPieChart3D
 * @see org.jfree.chart.StandardChartTheme#createLegacyTheme
 */
public class SampleCreatePieChart3D extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleCreatePieChart3D.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleCreatePieChart3D.class.getName());

    /** ϥե̾PNG */
    private static final String OUT_FILE_NAME_PNG =
        SAMPLE_FILE_DIRECTORY +  CLASS_NAME + ".png";

    /**
     * SampleCreatePieChart3D֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleCreatePieChart3D()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream png = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME_PNG);

            //쥬ơޤꤹ
            ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());

            //ߥդΥǡꤹ
            DefaultPieDataset dataset = new DefaultPieDataset();
            dataset.setValue("ٻ", 14.3);
            dataset.setValue("ɤǤʤ", 70.1);
            dataset.setValue("ٻʤ", 15.6);

            //ߥդ
            JFreeChart chart = ChartFactory.createPieChart3D(
                    //եȥ
                    "ջٻΨ",
                    //ǡå
                    dataset,
                    //Ƚɽ̵ͭ
                    true,
                    //ġåפɽ̵ͭ
                    false,
                    //URLưŪ̵ͭ
                    false);

            //PNGǥե¸
            png = new FileOutputStream(OUT_FILE_NAME_PNG);
            ChartUtilities.writeChartAsPNG(png, chart, 600, 400);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (png != null)
                {
                    png.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
