package net.tk_factory.sample.jfreechart;

import java.io.FileOutputStream;
import java.io.IOException;

import net.tk_factory.sample.AbstractSample;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.util.TableOrder;

/**
 * JFreeChartѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>ߥաʣˤޤ</li>
 * <li>ChartUtilities饹ѤơPNGǲϤޤ</li>
 * </ol>
 *
 * @author Takafumi Kondo (TK Factory)
 *
 * @see org.jfree.chart.ChartFactory#createMultiplePieChart
 * @see org.jfree.chart.StandardChartTheme#createLegacyTheme
 */
public class SampleCreateMultiplePieChart extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleCreateMultiplePieChart.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleCreateMultiplePieChart.class.getName());

    /** ϥե̾PNG */
    private static final String OUT_FILE_NAME_PNG =
        SAMPLE_FILE_DIRECTORY +  CLASS_NAME + ".png";

    /**
     * SampleCreateMultiplePieChart֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleCreateMultiplePieChart()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream png = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME_PNG);

            //쥬ơޤꤹ
            ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());

            //ߥաʣˤΥǡꤹ
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            //
            dataset.addValue(14.3, "", "ٻ");
            dataset.addValue(70.1, "", "ɤǤʤ");
            dataset.addValue(15.6, "", "ٻʤ");
            //20
            dataset.addValue(10.7, "20", "ٻ");
            dataset.addValue(68.0, "20", "ɤǤʤ");
            dataset.addValue(21.3, "20", "ٻʤ");
            //30
            dataset.addValue(11.6, "30", "ٻ");
            dataset.addValue(69.7, "30", "ɤǤʤ");
            dataset.addValue(18.7, "30", "ٻʤ");
            //40
            dataset.addValue(15.1, "40", "ٻ");
            dataset.addValue(71.7, "40", "ɤǤʤ");
            dataset.addValue(13.2, "40", "ٻʤ");
            //50
            dataset.addValue(14.6, "50", "ٻ");
            dataset.addValue(72.4, "50", "ɤǤʤ");
            dataset.addValue(13.0, "50", "ٻʤ");
            //60ʾ
            dataset.addValue(24.6, "60ʾ", "ٻ");
            dataset.addValue(68.5, "60ʾ", "ɤǤʤ");
            dataset.addValue(6.9, "60ʾ", "ٻʤ");

            //ߥաʣˤ
            JFreeChart chart = ChartFactory.createMultiplePieChart(
                    //եȥ
                    "ջٻΨ",
                    //ǡå
                    dataset,
                    //դν
                    TableOrder.BY_ROW,
                    //Ƚɽ̵ͭ
                    true,
                    //ġåפɽ̵ͭ
                    false,
                    //URLưŪ̵ͭ
                    false);

            //PNGǥե¸
            png = new FileOutputStream(OUT_FILE_NAME_PNG);
            ChartUtilities.writeChartAsPNG(png, chart, 600, 400);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (png != null)
                {
                    png.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
