package net.tk_factory.sample.jfreechart;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;

import net.tk_factory.sample.AbstractSample;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.date.DateUtilities;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.DefaultHighLowDataset;

/**
 * JFreeChartѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>­դޤ</li>
 * <li>ChartUtilities饹ѤơPNGǲϤޤ</li>
 * </ol>
 *
 * @author Takafumi Kondo (TK Factory)
 *
 * @see org.jfree.chart.ChartFactory#createCandlestickChart
 * @see org.jfree.chart.StandardChartTheme#createLegacyTheme
 */
public class SampleCreateCandlestickChart extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleCreateCandlestickChart.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleCreateCandlestickChart.class.getName());

    /** ϥե̾PNG */
    private static final String OUT_FILE_NAME_PNG =
        SAMPLE_FILE_DIRECTORY +  CLASS_NAME + ".png";

    /**
     * SampleCreateCandlestickChart֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleCreateCandlestickChart()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream png = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME_PNG);

            //쥬ơޤꤹ
            ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());

            //­դΥǡꤹ
            //
            Date[] date =
            {
                    DateUtilities.createDate(2009, 1, 1),
                    DateUtilities.createDate(2009, 2, 1),
                    DateUtilities.createDate(2009, 3, 1),
                    DateUtilities.createDate(2009, 4, 1),
                    DateUtilities.createDate(2009, 5, 1),
            };
            //
            double[] high =
            {
                    85.0D,
                    100.0D,
                    115.0D,
                    110.0D,
                    110.0D,
               };
            //
            double[] low =
            {
                    55.0D,
                    650.0D,
                    85.0D,
                    100.0D,
                    85.0D,
               };
            //
            double[] open =
            {
                    60.0D,
                    80.0D,
                    90.0D,
                    105.0D,
                    110.0D,
            };
            //
            double[] close =
            {
                    80.0D,
                    90.0D,
                    105.0D,
                    110.0D,
                    90.0D,
            };
            //ܥ塼
            double[] volume =
            {
                20.0D,
                10.0D,
                40.0D,
                30.0D,
                20.0D,
            };
            OHLCDataset dataset = new DefaultHighLowDataset("",
                    date,
                    high,
                    low,
                    open,
                    close,
                    volume);

            //­դ
            JFreeChart chart = ChartFactory.createCandlestickChart(
                    //եȥ
                    "",
                    //ƥ꼴٥
                    "ǯ",
                    //ͼ٥
                    "",
                    //ǡå
                    dataset,
                    //Ƚɽ̵ͭ
                    true);

            //PNGǥե¸
            png = new FileOutputStream(OUT_FILE_NAME_PNG);
            ChartUtilities.writeChartAsPNG(png, chart, 600, 400);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (png != null)
                {
                    png.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
