package net.tk_factory.sample.apache.poi.sheet;

import java.io.FileOutputStream;
import java.io.IOException;
import net.tk_factory.sample.AbstractSample;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/**
 * Apache POI-HSSFѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>HSSFWorkbook饹getSheetAt᥽åɤѤơǥåꤷƥȤ򻲾Ȥޤ</li>
 * <li>HSSFWorkbook饹getSheet᥽åɤѤơ̾ꤷƥȤ򻲾Ȥޤ</li>
 * </ol>
 * @author Takafumi Kondo (TK Factory)
 * @see org.apache.poi.hssf.usermodel.HSSFWorkbook#getSheetAt(int)
 * @see org.apache.poi.hssf.usermodel.HSSFWorkbook#getSheet(String)
 */
public class SampleGetSheet extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleGetSheet.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleGetSheet.class.getName());

    /** ϥե̾ */
    private static final String OUT_FILE_NAME =
        SAMPLE_FILE_DIRECTORY + CLASS_NAME + "Out.xls";

    /**
     * SampleGetSheet֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleGetSheet()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream out = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME);

            //֥å
            HSSFWorkbook workbook = new HSSFWorkbook();
            LOGGER.debug(workbook.toString());

            //Ȥɲä
            HSSFSheet sheet11 = workbook.createSheet();
            LOGGER.debug(sheet11.toString());
            HSSFSheet sheet12 = workbook.createSheet();
            LOGGER.debug(sheet12.toString());

            //ǥåꤷƥȤ򻲾Ȥ
            HSSFSheet sheet21 = workbook.getSheetAt(0);
            LOGGER.debug(sheet21.toString());

            //̾ꤷƥȤ򻲾Ȥ
            HSSFSheet sheet22 = workbook.getSheet("Sheet1");
            LOGGER.debug(sheet22.toString());

            //ե¸
            out = new FileOutputStream(OUT_FILE_NAME);
            workbook.write(out);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (out != null)
                {
                    out.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
