package net.tk_factory.sample.apache.poi.cell;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import net.tk_factory.sample.AbstractSample;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/**
 * Apache POI-HSSFѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>HSSFCell饹setCellValue᥽åɤѤơbooleanͤꤷޤ</li>
 * <li>HSSFCell饹setCellValue᥽åɤѤơCalendarͤꤷޤ</li>
 * <li>HSSFCell饹setCellValue᥽åɤѤơDateͤꤷޤ</li>
 * <li>HSSFCell饹setCellValue᥽åɤѤơdoubleͤꤷޤ</li>
 * <li>HSSFCell饹setCellValue᥽åɤѤơStringͤꤷޤ</li>
 * </ol>
 * @author Takafumi Kondo (TK Factory)
 * @see org.apache.poi.hssf.usermodel.HSSFCell#setCellValue(boolean)
 * @see org.apache.poi.hssf.usermodel.HSSFCell#setCellValue(Calendar)
 * @see org.apache.poi.hssf.usermodel.HSSFCell#setCellValue(Date)
 * @see org.apache.poi.hssf.usermodel.HSSFCell#setCellValue(double)
 * @see org.apache.poi.hssf.usermodel.HSSFCell#setCellValue(org.apache.poi.ss.usermodel.RichTextString)
 * @see org.apache.poi.hssf.usermodel.HSSFCell#setCellValue(String)
 * @see org.apache.poi.hssf.usermodel.HSSFCellStyle
 * @see org.apache.poi.hssf.usermodel.HSSFDataFormat
 */
public class SampleSetCellValue extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleSetCellValue.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleSetCellValue.class.getName());

    /** ϥե̾ */
    private static final String OUT_FILE_NAME =
        SAMPLE_FILE_DIRECTORY + CLASS_NAME + "Out.xls";

    /**
     * SampleSetCellValue֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleSetCellValue()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream out = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME);

            //֥å
            HSSFWorkbook workbook = new HSSFWorkbook();
            LOGGER.debug(workbook.toString());

            //Ȥɲä
            HSSFSheet sheet = workbook.createSheet();
            LOGGER.debug(sheet.toString());

            //Ԥɲä
            HSSFRow row0 = sheet.createRow(0);
            HSSFRow row1 = sheet.createRow(1);
            HSSFRow row2 = sheet.createRow(2);
            HSSFRow row3 = sheet.createRow(3);
            HSSFRow row4 = sheet.createRow(4);

            //booleanͤꤹ
            HSSFCell cell00 = row0.createCell(0);
            boolean val00 = true;
            cell00.setCellValue(val00);

            //Calendarͤꤹ
            HSSFCell cell10 = row1.createCell(0);
            Calendar val10 = Calendar.getInstance();
            cell10.setCellValue(val10);

            //񼰤ꤷCalendarͤꤹ
            HSSFCellStyle styleCalendar = workbook.createCellStyle();
            HSSFDataFormat formatCalendar = workbook.createDataFormat();
            styleCalendar.setDataFormat(formatCalendar.getFormat("yyyy/mm/dd"));
            HSSFCell cell11 = row1.createCell(1);
            Calendar val11 = Calendar.getInstance();
            cell11.setCellStyle(styleCalendar);
            cell11.setCellValue(val11);

            //Dateͤꤹ
            HSSFCell cell20 = row2.createCell(0);
            Date val20 = new Date();
            cell20.setCellValue(val20);

            //񼰤ꤷDateͤꤹ
            HSSFCellStyle styleDate = workbook.createCellStyle();
            HSSFDataFormat formatDate = workbook.createDataFormat();
            styleDate.setDataFormat(formatDate.getFormat("yyyy/mm/dd hh:mm"));
            HSSFCell cell21 = row2.createCell(1);
            Date val21 = new Date();
            cell21.setCellStyle(styleDate);
            cell21.setCellValue(val21);

            //doubleͤꤹ
            HSSFCell cell30 = row3.createCell(0);
            double val30 = 1234.56;
            cell30.setCellValue(val30);

            //񼰤ꤷdoubleͤꤹ
            HSSFCellStyle styleDouble = workbook.createCellStyle();
            HSSFDataFormat formatDouble = workbook.createDataFormat();
            styleDouble.setDataFormat(formatDouble.getFormat("#,##0.00"));
            HSSFCell cell31 = row3.createCell(1);
            double val31 = 1234.56;
            cell31.setCellStyle(styleDouble);
            cell31.setCellValue(val31);

            //Stringͤꤹ
            HSSFCell cell40 = row4.createCell(0);
            HSSFRichTextString val40 = new HSSFRichTextString("Test");
            cell40.setCellValue(val40);

            //Stringܸ͡ˤꤹ
            HSSFCell cell41 = row4.createCell(1);
            HSSFRichTextString val41 = new HSSFRichTextString("ƥ");
            cell41.setCellValue(val41);

            //ե¸
            out = new FileOutputStream(OUT_FILE_NAME);
            workbook.write(out);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (out != null)
                {
                    out.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
