package net.tk_factory.sample.apache.commons.lang;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import org.apache.commons.lang.time.DateUtils;

import junit.framework.TestCase;

/**
*
* Apache Commons Lang : DateUtils饹
*
* @see org.apache.commons.lang.time.DateUtils
*
*/
public class TestDateUtils extends TestCase
{

    /**
     * @see org.apache.commons.lang.time.DateUtils#isSameDay(java.util.Date, java.util.Date)
     */
    public void testIsSameDay1()
    {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();

        Date date1 = null;
        Date date2 = null;

        // 28 Mar 2002 13:45
        calendar1.set(2002, Calendar.MARCH, 28, 13, 45);
        date1 = calendar1.getTime();
        // 28 Mar 2002 06:01
        calendar2.set(2002, Calendar.MARCH, 28, 6, 1);
        date2 = calendar2.getTime();
        assertTrue(
                DateUtils.isSameDay(date1, date2));

        // 28 Mar 2002 13:45
        calendar1.set(2002, Calendar.MARCH, 28, 13, 45);
        date1 = calendar1.getTime();
        // 12 Mar 2002 13:45
        calendar2.set(2002, Calendar.MARCH, 12, 13, 45);
        date2 = calendar2.getTime();
        assertFalse(
                DateUtils.isSameDay(date1, date2));

        try
        {
            DateUtils.isSameDay(date1, null);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.isSameDay(null, date2);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.isSameDay((Date)null, (Date)null);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#isSameDay(Calendar, Calendar)
     */
    public void testIsSameDay2()
    {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();


        // 28 Mar 2002 13:45
        calendar1.set(2002, Calendar.MARCH, 28, 13, 45);
        // 28 Mar 2002 06:01
        calendar2.set(2002, Calendar.MARCH, 28, 6, 1);
        assertTrue(
                DateUtils.isSameDay(calendar1, calendar2));

        // 28 Mar 2002 13:45
        calendar1.set(2002, Calendar.MARCH, 28, 13, 45);
        // 12 Mar 2002 13:45
        calendar2.set(2002, Calendar.MARCH, 12, 13, 45);
        assertFalse(
                DateUtils.isSameDay(calendar1, calendar2));

        try
        {
            DateUtils.isSameDay(calendar1, null);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.isSameDay(null, calendar2);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.isSameDay((Calendar)null, (Calendar)null);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#isSameInstant(java.util.Date, java.util.Date)
     */
    public void testIsSameInstant1()
    {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();

        Date date1 = null;
        Date date2 = null;

        // 28 Mar 2002 13:45:00.000
        calendar1.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        date1 = calendar1.getTime();
        // 28 Mar 2002 13:45:00.000
        calendar2.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        date2 = calendar2.getTime();
        assertTrue(
                DateUtils.isSameInstant(date1, date2));

        // 28 Mar 2002 13:45:00.001
        calendar1.set(Calendar.MILLISECOND, 1);
        date1 = calendar1.getTime();
        // 28 Mar 2002 13:45:00.002
        calendar2.set(Calendar.MILLISECOND, 2);
        date2 = calendar2.getTime();
        assertFalse(
                DateUtils.isSameInstant(date1, date2));

        try
        {
            DateUtils.isSameInstant(date1, null);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.isSameInstant(null, date2);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.isSameInstant((Date)null, (Date)null);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#isSameInstant(Calendar, Calendar)
     */
    public void testIsSameInstant2()
    {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();

        // 28 Mar 2002 13:45:00.000
        calendar1.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        // 28 Mar 2002 13:45:00.000
        calendar2.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        assertTrue(
                DateUtils.isSameInstant(calendar1, calendar2));

        // 28 Mar 2002 13:45:00.001
        calendar1.set(Calendar.MILLISECOND, 1);
        // 28 Mar 2002 13:45:00.002
        calendar2.set(Calendar.MILLISECOND, 2);
        assertFalse(
                DateUtils.isSameInstant(calendar1, calendar2));

        try
        {
            DateUtils.isSameInstant(calendar1, null);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.isSameInstant(null, calendar2);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.isSameInstant((Calendar)null, (Calendar)null);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#isSameLocalTime(Calendar, Calendar)
     */
    public void testIsSameLocalTime()
    {
        Calendar calendar1 = Calendar.getInstance(Locale.US);
        Calendar calendar2 = Calendar.getInstance(Locale.US);

        // 28 Mar 2002 13:45:00.000US
        calendar1.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        // 28 Mar 2002 13:45:00.000US
        calendar2.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        assertTrue(
                DateUtils.isSameLocalTime(calendar1, calendar2));

        // 28 Mar 2002 13:45:00.001US
        calendar1.set(Calendar.MILLISECOND, 1);
        // 28 Mar 2002 13:45:00.002US
        calendar2.set(Calendar.MILLISECOND, 2);
        assertFalse(
                DateUtils.isSameLocalTime(calendar1, calendar2));

        Calendar calendar3 = Calendar.getInstance(Locale.US);
        Calendar calendar4 = Calendar.getInstance(Locale.JAPAN);

        // 28 Mar 2002 13:45:00.000US
        calendar3.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        // 28 Mar 2002 13:45:00.000JAPAN
        calendar4.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        assertFalse(
                DateUtils.isSameLocalTime(calendar1, calendar2));

        try
        {
            DateUtils.isSameLocalTime(calendar1, null);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.isSameLocalTime(null, calendar2);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.isSameLocalTime((Calendar)null, (Calendar)null);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#parseDate(String, String[])
     */
    public void testParseDate()
    {
        try
        {
            DateUtils.parseDate("2002/03/28", new String[]{"yyyyMMdd", "yyyy/MM/dd"});
        }
        catch (ParseException e) {
            // ParseExceptionȯʤϤ
            fail();
        }
        try
        {
            DateUtils.parseDate("28 Mar 2002", new String[]{"yyyyMMdd", "yyyy/MM/dd"});
            fail();
        }
        catch (ParseException e) {
            // ParseExceptionȯϤ
        }
        try
        {
            DateUtils.parseDate(null, new String[]{"yyyyMMdd", "yyyy/MM/dd"});
            fail();
        }
        catch (ParseException e) {
            // ParseExceptionȯʤϤ
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.parseDate("2002/03/28", null);
            fail();
        }
        catch (ParseException e) {
            // ParseExceptionȯʤϤ
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#addYears(Date, int)
     */
    public void testAddYears()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Mar 2003 13:45:00.000
        newDate = DateUtils.addYears(date, 1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.YEAR),
                2003);

        // 28 Mar 2001 13:45:00.000
        newDate = DateUtils.addYears(date, -1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.YEAR),
                2001);

        try
        {
            DateUtils.addYears(null, 1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#addMonths(Date, int)
     */
    public void testAddMonths()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Apr 2002 13:45:00.000
        newDate = DateUtils.addMonths(date, 1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.MONTH),
                Calendar.APRIL);

        // 28 Feb 2002 13:45:00.000
        newDate = DateUtils.addMonths(date, -1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.MONTH),
                Calendar.FEBRUARY);

        try
        {
            DateUtils.addMonths(null, 1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#addWeeks(Date, int)
     */
    public void testAddWeeks()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 04 Apr 2002 13:45:00.000
        newDate = DateUtils.addWeeks(date, 1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.MONTH),
                Calendar.APRIL);
        assertEquals(
                newCalendar.get(Calendar.DAY_OF_MONTH),
                4);

        // 21 Mar 2002 13:45:00.000
        newDate = DateUtils.addWeeks(date, -1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.MONTH),
                Calendar.MARCH);
        assertEquals(
                newCalendar.get(Calendar.DAY_OF_MONTH),
                21);

        try
        {
            DateUtils.addWeeks(null, 1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#addDays(Date, int)
     */
    public void testAddDays()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 29 Mar 2002 13:45:00.000
        newDate = DateUtils.addDays(date, 1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.DAY_OF_MONTH),
                29);

        // 27 Mar 2002 13:45:00.000
        newDate = DateUtils.addDays(date, -1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.DAY_OF_MONTH),
                27);

        try
        {
            DateUtils.addDays(null, 1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#addHours(Date, int)
     */
    public void testAddHours()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Mar 2002 14:45:00.000
        newDate = DateUtils.addHours(date, 1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.HOUR_OF_DAY),
                14);

        // 28 Mar 2002 12:45:00.000
        newDate = DateUtils.addHours(date, -1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.HOUR_OF_DAY),
                12);

        try
        {
            DateUtils.addHours(null, 1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#addMinutes(Date, int)
     */
    public void testAddMinutes()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Mar 2002 13:46:00.000
        newDate = DateUtils.addMinutes(date, 1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.MINUTE),
                46);

        // 28 Mar 2002 13:44:00.000
        newDate = DateUtils.addMinutes(date, -1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.MINUTE),
                44);

        try
        {
            DateUtils.addMinutes(null, 1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#addSeconds(Date, int)
     */
    public void testAddSeconds()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Mar 2002 13:45:01.000
        newDate = DateUtils.addSeconds(date, 1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.SECOND),
                1);

        // 28 Mar 2002 13:44:59.000
        newDate = DateUtils.addSeconds(date, -1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.MINUTE),
                44);
        assertEquals(
                newCalendar.get(Calendar.SECOND),
                59);

        try
        {
            DateUtils.addSeconds(null, 1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#addMilliseconds(Date, int)
     */
    public void testAddMilliseconds()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Mar 2002 13:45:00.001
        newDate = DateUtils.addMilliseconds(date, 1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.MILLISECOND),
                1);

        // 28 Mar 2002 13:44:999
        newDate = DateUtils.addMilliseconds(date, -1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.MINUTE),
                44);
        assertEquals(
                newCalendar.get(Calendar.SECOND),
                59);
        assertEquals(
                newCalendar.get(Calendar.MILLISECOND),
                999);

        try
        {
            DateUtils.addMilliseconds(null, 1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#setYears(Date, int)
     */
    public void testSetYears()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Mar 2003 13:45:00.000
        newDate = DateUtils.setYears(date, 2003);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.YEAR),
                2003);

        try
        {
            DateUtils.setYears(null, 2003);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#setMonths(Date, int)
     */
    public void testSetMonths()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Apr 2002 13:45:00.000
        newDate = DateUtils.setMonths(date, Calendar.APRIL);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.MONTH),
                Calendar.APRIL);

        try
        {
            DateUtils.setYears(null, Calendar.APRIL);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#setDays(Date, int)
     */
    public void testSetDays()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 29 Mar 2002 13:45:00.000
        newDate = DateUtils.setDays(date, 29);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.DAY_OF_MONTH),
                29);

        try
        {
            DateUtils.setDays(null, 29);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#setHours(Date, int)
     */
    public void testSetHours()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Mar 2002 14:45:00.000
        newDate = DateUtils.setHours(date, 14);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.HOUR_OF_DAY),
                14);

        try
        {
            DateUtils.setHours(null, 14);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#setMinutes(Date, int)
     */
    public void testSetMinutes()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Mar 2002 13:46:00.000
        newDate = DateUtils.setMinutes(date, 46);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.MINUTE),
                46);

        try
        {
            DateUtils.setMinutes(null, 14);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#setSeconds(Date, int)
     */
    public void testSetSeconds()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Mar 2002 13:45:01.000
        newDate = DateUtils.setSeconds(date, 1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.SECOND),
                1);

        try
        {
            DateUtils.setSeconds(null, 1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#setMilliseconds(Date, int)
     */
    public void testSetMilliseconds()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Mar 2002 13:45:00.001
        newDate = DateUtils.setMilliseconds(date, 1);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.MILLISECOND),
                1);

        try
        {
            DateUtils.setMilliseconds(null, 1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#round(Date, int)
     */
    public void testRound1()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Mar 2002 14:00:00.000
        newDate = DateUtils.round(date, Calendar.HOUR_OF_DAY);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.HOUR_OF_DAY),
                14);
        assertEquals(
                newCalendar.get(Calendar.MINUTE),
                0);

        // 29 Mar 2002 00:00:00.000
        newDate = DateUtils.round(date, Calendar.DAY_OF_MONTH);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.DAY_OF_MONTH),
                29);
        assertEquals(
                newCalendar.get(Calendar.HOUR_OF_DAY),
                0);

        try
        {
            DateUtils.round((Date)null, Calendar.HOUR_OF_DAY);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#round(Calendar, int)
     */
    public void testRound2()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);

        // 28 Mar 2002 14:00:00.000
        newCalendar = DateUtils.round(calendar, Calendar.HOUR_OF_DAY);
        assertEquals(
                newCalendar.get(Calendar.HOUR_OF_DAY),
                14);
        assertEquals(
                newCalendar.get(Calendar.MINUTE),
                0);

        // 29 Mar 2002 00:00:00.000
        newCalendar = DateUtils.round(calendar, Calendar.DAY_OF_MONTH);
        assertEquals(
                newCalendar.get(Calendar.DAY_OF_MONTH),
                29);
        assertEquals(
                newCalendar.get(Calendar.HOUR_OF_DAY),
                0);

        try
        {
            DateUtils.round((Calendar)null, Calendar.HOUR_OF_DAY);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#truncate(Date, int)
     */
    public void testTruncate1()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        Date date = null;
        Date newDate = null;

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);
        date = calendar.getTime();

        // 28 Mar 2002 13:00:00.000
        newDate = DateUtils.truncate(date, Calendar.HOUR_OF_DAY);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.HOUR_OF_DAY),
                13);
        assertEquals(
                newCalendar.get(Calendar.MINUTE),
                0);

        // 28 Mar 2002 00:00:00.000
        newDate = DateUtils.truncate(date, Calendar.DAY_OF_MONTH);
        newCalendar.setTime(newDate);
        assertEquals(
                newCalendar.get(Calendar.DAY_OF_MONTH),
                28);
        assertEquals(
                newCalendar.get(Calendar.HOUR_OF_DAY),
                0);

        try
        {
            DateUtils.truncate((Date)null, Calendar.HOUR_OF_DAY);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#truncate(Calendar, int)
     */
    public void testTruncate2()
    {
        Calendar calendar = Calendar.getInstance();
        Calendar newCalendar = Calendar.getInstance();

        // 28 Mar 2002 13:45:00.000
        calendar.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        calendar.set(Calendar.MILLISECOND, 0);

        // 28 Mar 2002 13:00:00.000
        newCalendar = DateUtils.truncate(calendar, Calendar.HOUR_OF_DAY);
        assertEquals(
                newCalendar.get(Calendar.HOUR_OF_DAY),
                13);
        assertEquals(
                newCalendar.get(Calendar.MINUTE),
                0);

        // 28 Mar 2002 00:00:00.000
        newCalendar = DateUtils.truncate(calendar, Calendar.DAY_OF_MONTH);
        assertEquals(
                newCalendar.get(Calendar.DAY_OF_MONTH),
                28);
        assertEquals(
                newCalendar.get(Calendar.HOUR_OF_DAY),
                0);

        try
        {
            DateUtils.truncate((Calendar)null, Calendar.HOUR_OF_DAY);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#iterator(Date, int)
     */
    @SuppressWarnings("unchecked")
    public void testIterator1()
    {
        Calendar focus = Calendar.getInstance();

        // 28 Mar 2002 13:45:00.000
        focus.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        focus.set(Calendar.MILLISECOND, 0);

        Iterator ite = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd(EEE)");

        List<String> list = new ArrayList<String>();

        // κǽ裱ޤǤϰ
        list.clear();
        ite = DateUtils.iterator(focus.getTime(), DateUtils.RANGE_MONTH_SUNDAY);
        while (ite.hasNext())
        {
            Calendar calendar = (Calendar)ite.next();

            list.add(sdf.format(calendar.getTime()));
        }
        assertEquals(list.toString(),
                "[2002/02/24(), 2002/02/25(), 2002/02/26(), 2002/02/27(), 2002/02/28(), 2002/03/01(), 2002/03/02(), " +
                 "2002/03/03(), 2002/03/04(), 2002/03/05(), 2002/03/06(), 2002/03/07(), 2002/03/08(), 2002/03/09(), " +
                 "2002/03/10(), 2002/03/11(), 2002/03/12(), 2002/03/13(), 2002/03/14(), 2002/03/15(), 2002/03/16(), " +
                 "2002/03/17(), 2002/03/18(), 2002/03/19(), 2002/03/20(), 2002/03/21(), 2002/03/22(), 2002/03/23(), " +
                 "2002/03/24(), 2002/03/25(), 2002/03/26(), 2002/03/27(), 2002/03/28(), 2002/03/29(), 2002/03/30(), " +
                 "2002/03/31(), 2002/04/01(), 2002/04/02(), 2002/04/03(), 2002/04/04(), 2002/04/05(), 2002/04/06()]");

        // κǽη裱ޤǤϰ
        list.clear();
        ite = DateUtils.iterator(focus.getTime(), DateUtils.RANGE_MONTH_MONDAY);
        while (ite.hasNext())
        {
            Calendar calendar = (Calendar)ite.next();

            list.add(sdf.format(calendar.getTime()));
        }
        assertEquals(list.toString(),
                "[2002/02/25(), 2002/02/26(), 2002/02/27(), 2002/02/28(), 2002/03/01(), 2002/03/02(), 2002/03/03(), " +
                 "2002/03/04(), 2002/03/05(), 2002/03/06(), 2002/03/07(), 2002/03/08(), 2002/03/09(), 2002/03/10(), " +
                 "2002/03/11(), 2002/03/12(), 2002/03/13(), 2002/03/14(), 2002/03/15(), 2002/03/16(), 2002/03/17(), " +
                 "2002/03/18(), 2002/03/19(), 2002/03/20(), 2002/03/21(), 2002/03/22(), 2002/03/23(), 2002/03/24(), " +
                 "2002/03/25(), 2002/03/26(), 2002/03/27(), 2002/03/28(), 2002/03/29(), 2002/03/30(), 2002/03/31()]");

        // ľ飱
        list.clear();
        ite = DateUtils.iterator(focus.getTime(), DateUtils.RANGE_WEEK_SUNDAY);
        while (ite.hasNext())
        {
            Calendar calendar = (Calendar)ite.next();

            list.add(sdf.format(calendar.getTime()));
        }
        assertEquals(list.toString(),
                "[2002/03/24(), 2002/03/25(), 2002/03/26(), 2002/03/27(), 2002/03/28(), 2002/03/29(), 2002/03/30()]");

        // ľη飱
        list.clear();
        ite = DateUtils.iterator(focus.getTime(), DateUtils.RANGE_WEEK_MONDAY);
        while (ite.hasNext())
        {
            Calendar calendar = (Calendar)ite.next();

            list.add(sdf.format(calendar.getTime()));
        }
        assertEquals(list.toString(),
                "[2002/03/25(), 2002/03/26(), 2002/03/27(), 2002/03/28(), 2002/03/29(), 2002/03/30(), 2002/03/31()]");

        // 飱
        list.clear();
        ite = DateUtils.iterator(focus.getTime(), DateUtils.RANGE_WEEK_RELATIVE);
        while (ite.hasNext())
        {
            Calendar calendar = (Calendar)ite.next();

            list.add(sdf.format(calendar.getTime()));
        }
        assertEquals(list.toString(),
                "[2002/03/28(), 2002/03/29(), 2002/03/30(), 2002/03/31(), 2002/04/01(), 2002/04/02(), 2002/04/03()]");

        // 濴Ȥ֡ʴ壳
        list.clear();
        ite = DateUtils.iterator(focus.getTime(), DateUtils.RANGE_WEEK_CENTER);
        while (ite.hasNext())
        {
            Calendar calendar = (Calendar)ite.next();

            list.add(sdf.format(calendar.getTime()));
        }
        assertEquals(list.toString(),
                "[2002/03/25(), 2002/03/26(), 2002/03/27(), 2002/03/28(), 2002/03/29(), 2002/03/30(), 2002/03/31()]");

        try
        {
            ite = DateUtils.iterator((Date)null, DateUtils.RANGE_WEEK_SUNDAY);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            ite = DateUtils.iterator(focus.getTime(), -1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#iterator(Calendar, int)
     */
    @SuppressWarnings("unchecked")
    public void testIterator2()
    {
        Calendar focus = Calendar.getInstance();

        // 28 Mar 2002 13:45:00.000
        focus.set(2002, Calendar.MARCH, 28, 13, 45, 00);
        focus.set(Calendar.MILLISECOND, 0);

        Iterator ite = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd(EEE)");

        List<String> list = new ArrayList<String>();

        // κǽ裱ޤǤϰ
        list.clear();
        ite = DateUtils.iterator(focus, DateUtils.RANGE_MONTH_SUNDAY);
        while (ite.hasNext())
        {
            Calendar calendar = (Calendar)ite.next();

            list.add(sdf.format(calendar.getTime()));
        }
        assertEquals(list.toString(),
                "[2002/02/24(), 2002/02/25(), 2002/02/26(), 2002/02/27(), 2002/02/28(), 2002/03/01(), 2002/03/02(), " +
                 "2002/03/03(), 2002/03/04(), 2002/03/05(), 2002/03/06(), 2002/03/07(), 2002/03/08(), 2002/03/09(), " +
                 "2002/03/10(), 2002/03/11(), 2002/03/12(), 2002/03/13(), 2002/03/14(), 2002/03/15(), 2002/03/16(), " +
                 "2002/03/17(), 2002/03/18(), 2002/03/19(), 2002/03/20(), 2002/03/21(), 2002/03/22(), 2002/03/23(), " +
                 "2002/03/24(), 2002/03/25(), 2002/03/26(), 2002/03/27(), 2002/03/28(), 2002/03/29(), 2002/03/30(), " +
                 "2002/03/31(), 2002/04/01(), 2002/04/02(), 2002/04/03(), 2002/04/04(), 2002/04/05(), 2002/04/06()]");

        // κǽη裱ޤǤϰ
        list.clear();
        ite = DateUtils.iterator(focus, DateUtils.RANGE_MONTH_MONDAY);
        while (ite.hasNext())
        {
            Calendar calendar = (Calendar)ite.next();

            list.add(sdf.format(calendar.getTime()));
        }
        assertEquals(list.toString(),
                "[2002/02/25(), 2002/02/26(), 2002/02/27(), 2002/02/28(), 2002/03/01(), 2002/03/02(), 2002/03/03(), " +
                 "2002/03/04(), 2002/03/05(), 2002/03/06(), 2002/03/07(), 2002/03/08(), 2002/03/09(), 2002/03/10(), " +
                 "2002/03/11(), 2002/03/12(), 2002/03/13(), 2002/03/14(), 2002/03/15(), 2002/03/16(), 2002/03/17(), " +
                 "2002/03/18(), 2002/03/19(), 2002/03/20(), 2002/03/21(), 2002/03/22(), 2002/03/23(), 2002/03/24(), " +
                 "2002/03/25(), 2002/03/26(), 2002/03/27(), 2002/03/28(), 2002/03/29(), 2002/03/30(), 2002/03/31()]");

        // ľ飱
        list.clear();
        ite = DateUtils.iterator(focus, DateUtils.RANGE_WEEK_SUNDAY);
        while (ite.hasNext())
        {
            Calendar calendar = (Calendar)ite.next();

            list.add(sdf.format(calendar.getTime()));
        }
        assertEquals(list.toString(),
                "[2002/03/24(), 2002/03/25(), 2002/03/26(), 2002/03/27(), 2002/03/28(), 2002/03/29(), 2002/03/30()]");

        // ľη飱
        list.clear();
        ite = DateUtils.iterator(focus, DateUtils.RANGE_WEEK_MONDAY);
        while (ite.hasNext())
        {
            Calendar calendar = (Calendar)ite.next();

            list.add(sdf.format(calendar.getTime()));
        }
        assertEquals(list.toString(),
                "[2002/03/25(), 2002/03/26(), 2002/03/27(), 2002/03/28(), 2002/03/29(), 2002/03/30(), 2002/03/31()]");

        // 飱
        list.clear();
        ite = DateUtils.iterator(focus, DateUtils.RANGE_WEEK_RELATIVE);
        while (ite.hasNext())
        {
            Calendar calendar = (Calendar)ite.next();

            list.add(sdf.format(calendar.getTime()));
        }
        assertEquals(list.toString(),
                "[2002/03/28(), 2002/03/29(), 2002/03/30(), 2002/03/31(), 2002/04/01(), 2002/04/02(), 2002/04/03()]");

        // 濴Ȥ֡ʴ壳
        list.clear();
        ite = DateUtils.iterator(focus, DateUtils.RANGE_WEEK_CENTER);
        while (ite.hasNext())
        {
            Calendar calendar = (Calendar)ite.next();

            list.add(sdf.format(calendar.getTime()));
        }
        assertEquals(list.toString(),
                "[2002/03/25(), 2002/03/26(), 2002/03/27(), 2002/03/28(), 2002/03/29(), 2002/03/30(), 2002/03/31()]");

        try
        {
            ite = DateUtils.iterator((Calendar)null, DateUtils.RANGE_WEEK_SUNDAY);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            ite = DateUtils.iterator(focus, -1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#getFragmentInDays(Date, int)
     */
    public void testGetFragmentInDays1()
    {
        Calendar calendar = Calendar.getInstance();

        // 28 Jan 2008
        calendar.set(2008, Calendar.JANUARY, 28);
        calendar.set(Calendar.MILLISECOND, 0);
        assertEquals(
                DateUtils.getFragmentInDays(calendar.getTime(), Calendar.MONTH),
                28);

        // 28 Feb 2008
        calendar.set(2008, Calendar.FEBRUARY, 28);
        calendar.set(Calendar.MILLISECOND, 0);
        assertEquals(
                DateUtils.getFragmentInDays(calendar.getTime(), Calendar.MONTH),
                28);

        // 28 Jan 2008
        calendar.set(2008, Calendar.JANUARY, 28);
        calendar.set(Calendar.MILLISECOND, 0);
        assertEquals(
                DateUtils.getFragmentInDays(calendar.getTime(), Calendar.YEAR),
                28);

        // 28 Feb 2008
        calendar.set(2008, Calendar.FEBRUARY, 28);
        calendar.set(Calendar.MILLISECOND, 0);
        assertEquals(
                DateUtils.getFragmentInDays(calendar.getTime(), Calendar.YEAR),
                59);

        // 28 Jan 2008
        calendar.set(2008, Calendar.JANUARY, 28);
        calendar.set(Calendar.MILLISECOND, 0);
        assertEquals(
                DateUtils.getFragmentInDays(calendar.getTime(), Calendar.MILLISECOND),
                0);

        try
        {
            DateUtils.getFragmentInDays(calendar.getTime(), -1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.getFragmentInDays((Date)null, Calendar.MONTH);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#getFragmentInDays(Calendar, int)
     */
    public void testGetFragmentInDays2()
    {
        Calendar calendar = Calendar.getInstance();

        // 28 Jan 2008
        calendar.set(2008, Calendar.JANUARY, 28);
        calendar.set(Calendar.MILLISECOND, 0);
        assertEquals(
                DateUtils.getFragmentInDays(calendar, Calendar.MONTH),
                28);

        // 28 Feb 2008
        calendar.set(2008, Calendar.FEBRUARY, 28);
        calendar.set(Calendar.MILLISECOND, 0);
        assertEquals(
                DateUtils.getFragmentInDays(calendar, Calendar.MONTH),
                28);

        // 28 Jan 2008
        calendar.set(2008, Calendar.JANUARY, 28);
        calendar.set(Calendar.MILLISECOND, 0);
        assertEquals(
                DateUtils.getFragmentInDays(calendar, Calendar.YEAR),
                28);

        // 28 Feb 2008
        calendar.set(2008, Calendar.FEBRUARY, 28);
        calendar.set(Calendar.MILLISECOND, 0);
        assertEquals(
                DateUtils.getFragmentInDays(calendar, Calendar.YEAR),
                59);

        // 28 Jan 2008
        calendar.set(2008, Calendar.JANUARY, 28);
        calendar.set(Calendar.MILLISECOND, 0);
        assertEquals(
                DateUtils.getFragmentInDays(calendar, Calendar.MILLISECOND),
                0);

        try
        {
            DateUtils.getFragmentInDays(calendar, -1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.getFragmentInDays((Calendar)null, Calendar.MONTH);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#getFragmentInHours(Date, int)
     */
    public void testGetFragmentInHours1()
    {
        Calendar calendar = Calendar.getInstance();

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInHours(calendar.getTime(), Calendar.DAY_OF_YEAR),
                7);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInHours(calendar.getTime(), Calendar.DAY_OF_YEAR),
                7);

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInHours(calendar.getTime(), Calendar.MONTH),
                //7);
                31);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInHours(calendar.getTime(), Calendar.MONTH),
                //127);
                151);

        // 16 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 16, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInHours(calendar.getTime(), Calendar.MILLISECOND),
                0);

        try
        {
            DateUtils.getFragmentInHours(calendar.getTime(), -1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.getFragmentInHours((Date)null, Calendar.DAY_OF_YEAR);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#getFragmentInHours(Calendar, int)
     */
    public void testGetFragmentInHours2()
    {
        Calendar calendar = Calendar.getInstance();

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInHours(calendar, Calendar.DAY_OF_YEAR),
                7);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInHours(calendar, Calendar.DAY_OF_YEAR),
                7);

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInHours(calendar, Calendar.MONTH),
                //7);
                31);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInHours(calendar, Calendar.MONTH),
                //127);
                151);

        // 16 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 16, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInHours(calendar, Calendar.MILLISECOND),
                0);

        try
        {
            DateUtils.getFragmentInHours(calendar, -1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.getFragmentInHours((Calendar)null, Calendar.DAY_OF_YEAR);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#getFragmentInMinutes(Date, int)
     */
    public void testGetFragmentInMinutes1()
    {
        Calendar calendar = Calendar.getInstance();

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMinutes(calendar.getTime(), Calendar.HOUR_OF_DAY),
                15);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMinutes(calendar.getTime(), Calendar.HOUR_OF_DAY),
                15);

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMinutes(calendar.getTime(), Calendar.DAY_OF_YEAR),
                435);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMinutes(calendar.getTime(), Calendar.DAY_OF_YEAR),
                435);

//        // 1 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMinutes(calendar.getTime(), Calendar.MONTH),
//                1875);

//        // 6 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMinutes(calendar.getTime(), Calendar.MONTH),
//                9075);

        // 16 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 16, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMinutes(calendar.getTime(), Calendar.MILLISECOND),
                0);

        try
        {
            DateUtils.getFragmentInMinutes(calendar.getTime(), -1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.getFragmentInMinutes((Date)null, Calendar.HOUR_OF_DAY);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#getFragmentInMinutes(Calendar, int)
     */
    public void testGetFragmentInMinutes2()
    {
        Calendar calendar = Calendar.getInstance();

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMinutes(calendar, Calendar.HOUR_OF_DAY),
                15);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMinutes(calendar, Calendar.HOUR_OF_DAY),
                15);

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMinutes(calendar, Calendar.DAY_OF_YEAR),
                435);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMinutes(calendar, Calendar.DAY_OF_YEAR),
                435);

//        // 1 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMinutes(calendar, Calendar.MONTH),
//                1875);

//        // 6 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMinutes(calendar, Calendar.MONTH),
//                9075);

        // 16 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 16, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMinutes(calendar, Calendar.MILLISECOND),
                0);

        try
        {
            DateUtils.getFragmentInMinutes(calendar, -1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.getFragmentInMinutes((Calendar)null, Calendar.HOUR_OF_DAY);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#getFragmentInSeconds(Date, int)
     */
    public void testGetFragmentInSeconds1()
    {
        Calendar calendar = Calendar.getInstance();

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInSeconds(calendar.getTime(), Calendar.MINUTE),
                10);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInSeconds(calendar.getTime(), Calendar.MINUTE),
                10);

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInSeconds(calendar.getTime(), Calendar.HOUR_OF_DAY),
                910);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInSeconds(calendar.getTime(), Calendar.HOUR_OF_DAY),
                910);

//        // 1 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInSeconds(calendar.getTime(), Calendar.DAY_OF_YEAR),
//                26110);

//        // 6 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInSeconds(calendar.getTime(), Calendar.DAY_OF_YEAR),
//                26110);

//        // 1 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInSeconds(calendar.getTime(), Calendar.MONTH),
//                112510);

//        // 6 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInSeconds(calendar.getTime(), Calendar.MONTH),
//                544510);

        // 16 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 16, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInSeconds(calendar.getTime(), Calendar.MILLISECOND),
                0);

        try
        {
            DateUtils.getFragmentInSeconds(calendar.getTime(), -1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.getFragmentInSeconds((Date)null, Calendar.MINUTE);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#getFragmentInSeconds(Calendar, int)
     */
    public void testGetFragmentInSeconds2()
    {
        Calendar calendar = Calendar.getInstance();

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInSeconds(calendar, Calendar.MINUTE),
                10);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInSeconds(calendar, Calendar.MINUTE),
                10);

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInSeconds(calendar, Calendar.HOUR_OF_DAY),
                910);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInSeconds(calendar, Calendar.HOUR_OF_DAY),
                910);

//        // 1 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInSeconds(calendar, Calendar.DAY_OF_YEAR),
//                26110);

//        // 6 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInSeconds(calendar, Calendar.DAY_OF_YEAR),
//                26110);

//        // 1 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInSeconds(calendar, Calendar.MONTH),
//                112510);

//        // 6 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInSeconds(calendar, Calendar.MONTH),
//                544510);

        // 16 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 16, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInSeconds(calendar, Calendar.MILLISECOND),
                0);

        try
        {
            DateUtils.getFragmentInSeconds(calendar, -1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.getFragmentInSeconds((Calendar)null, Calendar.MINUTE);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#getFragmentInMilliseconds(Date, int)
     */
    public void testGetFragmentInMilliseconds1()
    {
        Calendar calendar = Calendar.getInstance();

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMilliseconds(calendar.getTime(), Calendar.SECOND),
                538);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMilliseconds(calendar.getTime(), Calendar.SECOND),
                538);

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMilliseconds(calendar.getTime(), Calendar.MINUTE),
                10538);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMilliseconds(calendar.getTime(), Calendar.MINUTE),
                10538);

//        // 1 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMilliseconds(calendar.getTime(), Calendar.HOUR_OF_DAY),
//                910538);

//        // 6 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMilliseconds(calendar.getTime(), Calendar.HOUR_OF_DAY),
//                910538);

//        // 1 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMilliseconds(calendar.getTime(), Calendar.DAY_OF_YEAR),
//                26110538);

//        // 6 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMilliseconds(calendar.getTime(), Calendar.DAY_OF_YEAR),
//                26110538);

//        // 1 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMilliseconds(calendar.getTime(), Calendar.MONTH),
//                112510538);

//        // 6 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMilliseconds(calendar.getTime(), Calendar.MONTH),
//                544510538);

        // 16 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 16, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMilliseconds(calendar.getTime(), Calendar.MILLISECOND),
                0);

        try
        {
            DateUtils.getFragmentInMilliseconds(calendar.getTime(), -1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.getFragmentInMilliseconds((Date)null, Calendar.SECOND);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }

    /**
     * @see org.apache.commons.lang.time.DateUtils#getFragmentInMilliseconds(Calendar, int)
     */
    public void testGetFragmentInMilliseconds2()
    {
        Calendar calendar = Calendar.getInstance();

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMilliseconds(calendar, Calendar.SECOND),
                538);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMilliseconds(calendar, Calendar.SECOND),
                538);

        // 1 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMilliseconds(calendar, Calendar.MINUTE),
                10538);

        // 6 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMilliseconds(calendar, Calendar.MINUTE),
                10538);

//        // 1 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMilliseconds(calendar, Calendar.HOUR_OF_DAY),
//                910538);

//        // 6 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMilliseconds(calendar, Calendar.HOUR_OF_DAY),
//                910538);

//        // 1 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMilliseconds(calendar, Calendar.DAY_OF_YEAR),
//                26110538);

//        // 6 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMilliseconds(calendar, Calendar.DAY_OF_YEAR),
//                26110538);

//        // 1 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 1, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMilliseconds(calendar, Calendar.MONTH),
//                112510538);

//        // 6 Jan 2008 07:15:10.538
//        calendar.set(2008, Calendar.JANUARY, 6, 7, 15, 10);
//        calendar.set(Calendar.MILLISECOND, 538);
//        assertEquals(
//                DateUtils.getFragmentInMilliseconds(calendar, Calendar.MONTH),
//                544510538);

        // 16 Jan 2008 07:15:10.538
        calendar.set(2008, Calendar.JANUARY, 16, 7, 15, 10);
        calendar.set(Calendar.MILLISECOND, 538);
        assertEquals(
                DateUtils.getFragmentInMilliseconds(calendar, Calendar.MILLISECOND),
                0);

        try
        {
            DateUtils.getFragmentInMilliseconds(calendar, -1);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
        try
        {
            DateUtils.getFragmentInMilliseconds((Calendar)null, Calendar.SECOND);
            fail();
        }
        catch (IllegalArgumentException e) {
            // IllegalArgumentExceptionȯϤ
        }
    }
}
