/**
 *
 */
package fs.game.reversi.sound;

import java.util.HashMap;
import java.util.Map;

import android.content.Context;
import android.media.AudioManager;
import android.media.SoundPool;

/**
 * SE(Sound Effect)マネージャ
 *
 * @author noguchi
 *
 */
public class SEManager {
	private static final int MAX_STREAM = 50;

	private Context context = null;
	private SoundPool soundPool = null;
	private Map<String, Integer> loadedSound = new HashMap<String, Integer>(MAX_STREAM);

	public SEManager(Context context) {
		this.context = context;
		this.soundPool = new SoundPool(MAX_STREAM, AudioManager.STREAM_MUSIC, 0);

	}

	public synchronized void storeSound(String soundKey, int resourceID) {
		if (!loadedSound.containsKey(soundKey)) {
			int sound = soundPool.load(context, resourceID, 1);
			loadedSound.put(soundKey, sound);
		}
	}

	public synchronized void playSound(String soundKey, float leftVolume, float rightVolume, int priority) {
		if (loadedSound.containsKey(soundKey)) {
			int sound = loadedSound.get(soundKey);
			soundPool.play(sound, leftVolume, rightVolume, priority, 0, 1.0f);
		}
	}

	public synchronized void playSound(String soundKey, float leftVolume, float rightVolume) {
		playSound(soundKey, leftVolume, rightVolume, 1);
	}

	public synchronized void playSound(String soundKey) {
		playSound(soundKey, 1.0f, 1.0f);
	}

}
