/**
 *
 */
package fs.game.reversi.gl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import javax.microedition.khronos.opengles.GL10;

/**
 * システム全体のテクスチャを管理するクラス
 *
 * @author noguchi
 */
public class TextureManager {
	// テクスチャを管理する領域
	private static Map<Integer, Integer> textures = new Hashtable<Integer, Integer>();

	/**
	 * テクスチャを追加する
	 *
	 * @param resId
	 * @param texId
	 */
	public static final void addTexture(int resId, int texId){
		 textures.put(resId, texId);
	}

	/**
	 * テクスチャがすでにロードされて登録されているかを返す
	 *
	 * @param resId
	 * @return
	 */
	public static final boolean contains(int resId){
		return textures.containsKey(resId);
	}

	/**
	 * テクスチャを取得する
	 *
	 * @param resId
	 * @return
	 */
	public static final int getTexture(int resId){
		if( contains(resId)){
			return textures.get(resId);
		}else{
			return 0;
		}
	}

	/**
	 * テクスチャを削除する
	 *
	 * @param resId
	 */
	public static final void deleteTexture(GL10 gl, int resId){
		if( textures.containsKey(resId)){
			int[] texId = new int[1];
			texId[0] = textures.get(resId);

			gl.glDeleteTextures(1, texId, 0);
			textures.remove(resId);
		}
	}

	/**
	 * すべてのテクスチャを削除する
	 */
	public static final void deleteAll(GL10 gl){
		List<Integer> keys = new ArrayList<Integer>(textures.keySet());

		for(Integer key : keys ){
			deleteTexture(gl, key);
		}
	}

}
