/**
 *
 */
package fs.game.reversi.gl;

import java.util.ArrayList;
import java.util.List;

import javax.microedition.khronos.opengles.GL10;

import android.content.Context;
import fs.game.reversi.game.Stone;
import fs.game.reversi.sound.SEManager;
import fs.game.reversi.sound.SoundManager;

/**
 * @author noguchi
 *
 */
public class SquareObject extends GLBasicRenderer implements GLToucheableObject {

	private int grassTexture = 0;

	public int x = 0;
	public int y = 0;

	private float squareLeft = 0.0f;

	private float objectWidth = 0.0f;

	private float squareTop = 0.0f;

	private float objectHeight = 0.0f;

	/**
	 * 幅
	 */
	private float sw = 0.2f;

	/**
	 * 高さ
	 */
	private float sh = 0.2f;

	/**
	 * 幅の間
	 */
	private float wspacing = 0.008f;

	/**
	 * 高さの間
	 */
	private float hspacing = 0.01f;

	private List<SquareObject.onSquareEvent> events = new ArrayList<SquareObject.onSquareEvent>();

	private PieceObject piece = null;

	/**
	 *
	 * @param context
	 * @param width
	 * @param height
	 * @param x
	 * @param y
	 */
	public SquareObject(Context context, int width, int height, int x, int y) {
		super(context, width, height);

		this.x = x;
		this.y = y;
	}

	/*
	 * (非 Javadoc)
	 *
	 * @see
	 * fs.game.reversi.gl.GLBasicRenderer#onAfterSurfaceChanged(javax.microedition
	 * .khronos.opengles.GL10, int, int)
	 */
	@Override
	protected void onAfterSurfaceChanged(GL10 gl, int width, int height) {
		if (TextureManager.contains(fs.game.reversi.R.drawable.grass)) {
			// テクスチャのオブジェクトの取得
			this.grassTexture = TextureManager.getTexture(fs.game.reversi.R.drawable.grass);
		} else {
			// テクスチャの生成を行う
			this.grassTexture = GLUtility.loadTexture(gl, context.getResources(), fs.game.reversi.R.drawable.grass);
		}

		if (piece != null) {
			piece.onSurfaceChanged(gl, width, height);
		}
	}

	/*
	 * (非 Javadoc)
	 *
	 * @see fs.game.reversi.gl.GLBasicRenderer#onTouched(float, float)
	 */
	@Override
	public synchronized void onTouched(float touchedX, float touchedY) {
		// 自分の描画範囲を求める
		float nl = squareLeft + (squareLeft * 0.125f);
		float nt = squareTop + (squareTop * 0.125f);
		float cr = squareLeft + objectWidth;
		float cb = squareTop + objectHeight;

		if ((nl <= touchedX && touchedX <= cr) && (nt <= touchedY && touchedY <= cb)) {
			if (events != null && events.size() > 0) {
				for (SquareObject.onSquareEvent event : events) {
					try {
						event.onTouched(this, x, y);
					} catch (Exception ex) {
						// 例外はムシ
					}
				}
			}
		}

		if (piece != null) {
			piece.onTouched(x, y);
		}
	}

	/*
	 * (非 Javadoc)
	 *
	 * @see
	 * fs.game.reversi.gl.GLBasicRenderer#render(javax.microedition.khronos.
	 * opengles.GL10)
	 */
	@Override
	public void render(GL10 gl) {
		this.squareLeft = (float) x * (sw + wspacing) + offset_X;
		this.squareTop = (float) y * (sh + hspacing) + offset_Y;

		objectWidth = sw;
		objectHeight = sh;

		GLUtility.drawTexture(gl, squareLeft, squareTop, sw, sh, grassTexture, 1.0f, 1.0f, 1.0f, 1.0f);

		if (piece != null) {
			piece.render(gl);
		}
	}

	public void clearPiece() {
		piece = null;
	}

	/**
	 * @return left
	 */
	public float getLeft() {
		return left;
	}

	/**
	 * @return top
	 */
	public float getTop() {
		return top;
	}

	/**
	 * @return sw
	 */
	public float getSquareWidth() {
		return sw;
	}

	/**
	 * @param sw セットする sw
	 */
	public void setSquareWidth(float sw) {
		this.sw = sw;
	}

	/**
	 * @return sh
	 */
	public float getSquareHeight() {
		return sh;
	}

	/**
	 * @param sh セットする sh
	 */
	public void setSquareHeight(float sh) {
		this.sh = sh;
	}

	/**
	 * @return piece
	 */
	public PieceObject getPiece() {
		return piece;
	}

	public boolean existsPiece() {
		return piece != null;
	}

	public void addEventHandler(SquareObject.onSquareEvent event) {
		events.add(event);
	}

	public void removeEventHandler(SquareObject.onSquareEvent event) {
		events.remove(event);
	}

	public void createPiece(Stone stone) {
		if (piece == null) {
			SoundManager soundMng = SoundManager.getInstance(context);
			SEManager se = soundMng.getSEManager();
			se.playSound("Hit", 1.0f, 1.0f, 10);

			piece = new PieceObject(context, width, height, (float) (x * (sw + wspacing)) + offset_X, (float) (y * (sh + hspacing)) + offset_Y, sw, sh);
			piece.setFace(stone);
		}
	}

	public interface onSquareEvent {
		void onTouched(SquareObject square, int x, int y);
	}
}
