/**
 *
 */
package fs.game.reversi.gl;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.view.MotionEvent;
import android.view.SurfaceHolder;

/**
 * @author noguchi
 *
 */
public class GLCustomSurfaceView extends GLSurfaceView {
	private float width = 0.0f;
	private float height = 0.0f;

	private GLBasicRenderer renderer = null;

	public GLCustomSurfaceView(Context context) {
		super(context);

		// タッチイベントを取る
		setFocusable(true);
	}

	/* (非 Javadoc)
	 * @see android.view.View#onTouchEvent(android.view.MotionEvent)
	 */
	@Override
	public boolean onTouchEvent(MotionEvent event) {
		if( renderer != null ){
			renderer.onTouched(event.getX(), event.getY());
		}

		return false;
	}

	/* (非 Javadoc)
	 * @see android.opengl.GLSurfaceView#surfaceChanged(android.view.SurfaceHolder, int, int, int)
	 */
	@Override
	public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
		super.surfaceChanged(holder, format, w, h);

		this.width = w;
		this.height = h;
	}

	/* (非 Javadoc)
	 * @see android.opengl.GLSurfaceView#setRenderer(android.opengl.GLSurfaceView.Renderer)
	 */
	@Override
	public void setRenderer(Renderer renderer) {
		super.setRenderer(renderer);
		this.renderer = (GLBasicRenderer)renderer;
	}

}
