/**
 *
 */
package fs.game.reversi.gl;

import javax.microedition.khronos.opengles.GL10;

import android.content.Context;
import fs.game.reversi.Global;

/**
 * @author noguchi
 *
 */
public class BattleScreenRender extends GLBasicRenderer implements
		GLToucheableObject {

	private BoardObject board = null;
	private int backgroundTexture = 0;
	private boolean initializeFlag = false;

	/**
	 * @param context
	 * @param width
	 * @param height
	 */
	public BattleScreenRender(Context context, int width, int height) {
		super(context, width, height);

		board = new BoardObject(context, width, height);
		board.offset_X = -1.25f;
		board.offset_Y = -0.75f;
		board.initialize();
	}

	/* (非 Javadoc)
	 * @see fs.game.reversi.gl.GLBasicRenderer#onTouched(float, float)
	 */
	@Override
	public void onTouched(float x, float y) {
		if( initializeFlag ){
			// GameStartしていないと押しても意味がないように
			float xx = (Math.abs( Global.Left ) + Math.abs( Global.Right )) * (x - width / 2.0f)  / width;
			float yy = (Math.abs( Global.Top )  + Math.abs( Global.Bottom )) * ( y - height / 2.0f) / height;
			board.onTouched(xx, yy);
		}
	}

	/* (非 Javadoc)
	 * @see fs.game.reversi.gl.GLBasicRenderer#onAfterSurfaceChanged(javax.microedition.khronos.opengles.GL10, int, int)
	 */
	@Override
	protected void onAfterSurfaceChanged(GL10 gl, int width, int height) {
		super.onAfterSurfaceChanged(gl, width, height);

		if (TextureManager.contains(fs.game.reversi.R.drawable.back)) {
			// テクスチャのオブジェクトの取得
			this.backgroundTexture = TextureManager
					.getTexture(fs.game.reversi.R.drawable.back);
		} else {
			// テクスチャの生成を行う
			this.backgroundTexture = GLUtility.loadTexture(gl,
					context.getResources(), fs.game.reversi.R.drawable.back);
		}

		board.onSurfaceChanged(gl, width, height);
		board.onAfterSurfaceChanged(gl, width, height);
	}

	/* (非 Javadoc)
	 * @see fs.game.reversi.gl.GLBasicRenderer#render(javax.microedition.khronos.opengles.GL10)
	 */
	@Override
	public void render(GL10 gl) {
		super.render(gl);

		// 背景の描画
		GLUtility.drawTexture(gl, 0.0f, 0.0f, 3.0f, 2.0f, backgroundTexture, 1.0f, 1.0f, 1.0f, 1.0f);

		board.render(gl);
	}

	/**
	 * オセロ板の初期化
	 */
	public void initializeGame(){
		initializeFlag = true;

		board.initializeGame();
	}

	/**
	 * @return board
	 */
	public BoardObject getBoard() {
		return board;
	}
}
