package fs.game.reversi.game;

import fs.game.core.BattlesTable;

public class ReversiBoard implements BattlesTable {
	private Stone[] data = new Stone[8 * 8];
	private int[] log = new int[8 * 8];
	private int count = 0;

	public ReversiBoard() {
		data = new Stone[8 * 8];
		log = new int[8 * 8];
		count = 0;

		// 初期データ
		put(indexOf(3, 3), true);
		put(indexOf(4, 3), false);
		put(indexOf(3, 4), false);
		put(indexOf(4, 4), true);
	}

	public ReversiBoard(Stone[] data, int[] log, int count) {
		this.data = data;
		this.log = log;
		this.count = count;
	}

	static int[][] Durations = { { 0, -1 }, { 1, -1 }, { 1, 0 }, { 1, 1 }, { 0, 1 }, { -1, 1 }, { -1, 0 }, { -1, -1 } };

	protected MoveAction move(int x, int y, boolean white) {
		int index = indexOf(x, y);

		MoveAction action = new MoveAction();
		action.index = index;
		action.white = white;

		action.valid = data[index] == null;

		if (action.valid) {
			/* とりあえず愚直に８方向検索 */
			int[] has = count(x, y, white);

			int[] levelCount = new int[7];

			action.valid = false;
			for (int dur = 0; dur < 8; dur++) {
				for (int pos = 1; pos <= has[dur]; pos++) {
					int level = pos - 1;
					action.surrounded[level][levelCount[level]++] = indexOf(x + Durations[dur][0] * pos, y + Durations[dur][1] * pos);
					action.valid = true;
				}
			}
		}

		return action;
	}

	private int[] count(int x, int y, boolean white) {
		// 時計回りに8方向
		int[] reverse = new int[8];

		for (int pos = 1; pos < 7; pos++) {
			for (int dur = 0; dur < 8; dur++) {
				int index = indexOf0(x + Durations[dur][0] * pos, y + Durations[dur][1] * pos);

				if (reverse[dur] > 0 || index == -1) {
					continue;
				} else if (data[index] == null) {
					reverse[dur] = 9;// out of bounds.
				} else if (data[index] == Stone.White ^ white) {
					reverse[dur]--;
				} else {
					reverse[dur] = reverse[dur] == 0 ? 9 : Math.abs(reverse[dur]);
				}
			}
		}

		for (int i = 0; i < 8; i++) {
			if (reverse[i] == 9) {
				reverse[i] = 0;
			}
		}

		return reverse;
	}

	private static int indexOf0(int x, int y) {
		if (x < 0 || x > 7 || y < 0 || y > 7) {
			return -1;
		}
		return y << 3 | x;
	}

	public Stone getStone(int x, int y) {
		return data[indexOf(x, y)];
	}

	public Stone[] getData() {
		Stone[] ret = new Stone[data.length];

		System.arraycopy(data, 0, ret, 0, data.length);

		return ret;
	}

	protected void log(int index, boolean white) {
		int l = white ? index : index | 0x80000000;
		log[count++] = l;
	}

	protected void put(int index, boolean white) {
		data[index] = white ? Stone.White : Stone.Black;
	}

	public static int getX(int index) {
		return index & 7;
	}

	public static int getY(int index) {
		return index >> 3;
	}

	public static int indexOf(int x, int y) {
		if (x < 0 || x > 7 || y < 0 || y > 7) {
			// TODO message
			throw new IndexOutOfBoundsException();
		}
		return y << 3 | x;
	}

	public class MoveAction {
		private int index;
		private boolean white;
		private boolean valid = false;
		int surrounded[][] = new int[6][8];

		private MoveAction() {
		}

		public boolean isWhite() {
			return white;
		}

		public int getIndex() {
			return index;
		}

		public boolean isValid() {
			return valid;
		}

		public int getLevelCount() {
			int count = 0;
			for (int[] level : surrounded) {
				if (level[0] == 0) {
					return count;
				} else {
					count++;
				}
			}

			return count;
		}

		public int[] getSurrounded(int level) {
			return surrounded[level];
		}

		public void consume() {
			if (!valid) {
				return;
			}

			put(index, white);
			log(index, white);

			for (int[] level : surrounded) {
				for (int move : level) {
					if (move == 0) {
						break;
					}

					put(move, white);
				}
			}
		}
	}
}
