package fs.game.reversi;

import android.app.Activity;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup.LayoutParams;
import android.view.Window;
import android.view.WindowManager;
import fs.game.reversi.game.ActionDispatcher;
import fs.game.reversi.game.Player;
import fs.game.reversi.game.ReversiBoard;
import fs.game.reversi.game.ReversiBoard.MoveAction;
import fs.game.reversi.game.Stone;
import fs.game.reversi.gl.BattleScreenRender;
import fs.game.reversi.gl.BoardObject;
import fs.game.reversi.gl.GLCustomSurfaceView;
import fs.game.reversi.gl.TextureManager;
import fs.game.reversi.sound.BGMManager;
import fs.game.reversi.sound.SEManager;
import fs.game.reversi.sound.SoundManager;

public class MainActivity extends Activity {

	private GLSurfaceView.Renderer renderer = null;
	private SoundManager soundMng = null;
	private GameThread gameThread = null;
	private RemoteThread remoteThread = null;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		// フルスクリーンモードにする
		getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);

		// タイトルバーを非表示
		requestWindowFeature(Window.FEATURE_NO_TITLE);

		Global.mainActivity = this;

		Global.actionDispatcher = new ActionDispatcher();
		Global.board = new ReversiBoard();

		// GameThreadを作る
		gameThread = new GameThread();

		remoteThread = new RemoteThread();

		// TODO とりあえず両プレイヤーをスタブで
		Global.black = new Player.PlayerStub(false);
		Global.white = new Player.PlayerStub(true);
		Global.localUser = Global.black;

		// 画面サイズ取得
		WindowManager wm = (WindowManager) getSystemService(WINDOW_SERVICE);

		Display disp = wm.getDefaultDisplay();
		int width = disp.getWidth();
		int height = disp.getHeight();

		renderer = new BattleScreenRender(this, width, height);

		// GLSurfaceView
		GLCustomSurfaceView glSurfaceView = new GLCustomSurfaceView(this);
		glSurfaceView.setRenderer(renderer);

		setContentView(glSurfaceView);

		View buttons = View.inflate(this, R.layout.main, null);
		addContentView(buttons, new LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT));

		gameThread.start();
		remoteThread.start();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onDestroy()
	 */
	@Override
	protected void onDestroy() {
		// TODO 自動生成されたメソッド・スタブ
		super.onDestroy();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onPause()
	 */
	@Override
	protected void onPause() {
		super.onPause();

		if (gameThread != null) {
			gameThread.suspendThread();
		}

		if (soundMng != null) {
			soundMng.stopBGMAll();
		}
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onRestart()
	 */
	@Override
	protected void onRestart() {
		super.onRestart();

	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onResume()
	 */
	@Override
	protected void onResume() {
		super.onResume();

		if (gameThread != null) {
			gameThread.resumeThread();
		}
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onSaveInstanceState(android.os.Bundle)
	 */
	@Override
	protected void onSaveInstanceState(Bundle outState) {
		// TODO 自動生成されたメソッド・スタブ
		super.onSaveInstanceState(outState);
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStart()
	 */
	@Override
	protected void onStart() {
		super.onStart();

		soundMng = SoundManager.getInstance(this);
		BGMManager mainSound = soundMng.getBGM("MainSound");
		mainSound.loadBGM(R.raw.canonvar);
		SEManager se = soundMng.getSEManager();
		se.storeSound("Hit", R.raw.medal_on_mat);

		mainSound.start();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStop()
	 */
	@Override
	protected void onStop() {
		super.onStop();

		if (Global.gl != null) {
			TextureManager.deleteAll(Global.gl);
		}
	}

	/**
	 * テスト用
	 * 
	 * @param v
	 */
	public void onServerModeButtonClick(View v) {
		findViewById(R.id.Buttons).setVisibility(View.GONE);

		if (renderer instanceof BattleScreenRender) {
			((BattleScreenRender) renderer).initializeGame();
		}
	}

	/**
	 * テスト用
	 * 
	 * @param v
	 */
	public void onClientModeButtonClick(View v) {

	}

	public void onNewGameButtonCLick(View v) {

	}

	// FIXME あとで、MoveActionでは無くイベント情報を生成してUIに送信
	public void dispatchMoveEvent(MoveAction action) {
		if (renderer instanceof BattleScreenRender) {
			BattleScreenRender r = ((BattleScreenRender) renderer);

			Stone stone = action.isWhite() ? Stone.White : Stone.Black;

			BoardObject board = r.getBoard();

			int x = ReversiBoard.getX(action.getIndex());
			int y = ReversiBoard.getY(action.getIndex());

			board.put(x, y, stone);
			for (int level = 0; level < 6; level++) {
				for (int move : action.getSurrounded(level)) {
					if (move == 0) {
						continue;
					}

					x = ReversiBoard.getX(move);
					y = ReversiBoard.getY(move);
					board.put(x, y, stone);
				}
			}
		}
	}
}