package fs.game.core.dc.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;

import fs.game.core.dc.Discovery;
import fs.game.core.dc.DiscoveryException;
import fs.game.core.dc.Sonar;

public class UdpDiscovery implements Discovery<UdpHost> {

	public static final String ORIGINAL = "org";

	public static final String REFLECTED = "ref";

	public static final int PORT = 5454;

	@Override
	public void ping() throws DiscoveryException {
		sendData(ORIGINAL);
	}

	protected void sendData(String value) throws DiscoveryException {
		// FIXME address
		InetSocketAddress address = new InetSocketAddress("192.168.1.255", PORT);

		byte[] sendBuffer = value.getBytes();

		try {
			DatagramPacket sendPacket = new DatagramPacket(sendBuffer, sendBuffer.length, address);
			new DatagramSocket().send(sendPacket);
		} catch (SocketException e) {
			throw new DiscoveryException(e);
		} catch (IOException e) {
			throw new DiscoveryException(e);
		}
	}

	@Override
	public void search(Sonar<UdpHost> sonar) throws DiscoveryException {
		DatagramSocket receiveSocket;
		try {
			receiveSocket = new DatagramSocket(PORT);
		} catch (IOException e) {
			throw new DiscoveryException(e);
		}

		try {
			byte buff[] = new byte[1024];
			DatagramPacket packet = new DatagramPacket(buff, buff.length);

			// FIXME use interrupt (close socket)
			while (true) {
				receiveSocket.receive(packet);

				if (itsMe(packet)) {
					// through
				} else if (isPing(packet)) {
					sendData(REFLECTED);
				} else {
					UdpHost host = decode(packet);
					sonar.discovered(host);
				}
			}
		} catch (IOException e) {
			throw new DiscoveryException(e);
		} finally {
			receiveSocket.close();
		}
	}

	private boolean itsMe(DatagramPacket packet) {
		// TODO implement logic
		return false;
	}

	private boolean isPing(DatagramPacket packet) {
		// TODO implement logic
		return false;
	}

	protected UdpHost decode(DatagramPacket packet) {
		// TODO implement decode
		return new UdpHost();
	}
}
