package fs.game.core.dc.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

import fs.game.core.dc.Discovery;
import fs.game.core.dc.DiscoveryException;
import fs.game.core.dc.Sonar;

public class HttpDiscovery implements Discovery<HttpHost> {

	@Override
	public void ping() throws DiscoveryException {
		try {
			// FIXME URL
			new URL("http://localhost:8080/ping").openConnection().getContent();
		} catch (MalformedURLException e) {
			throw new DiscoveryException("ARIEHEN", e);
		} catch (IOException e) {
			throw new DiscoveryException(e);
		}
	}

	@Override
	public void search(Sonar<HttpHost> sonar) throws DiscoveryException {
		URL url;
		try {
			// FIXME URL
			url = new URL("http://localhost:8080/commet");
		} catch (MalformedURLException e) {
			throw new DiscoveryException("ARIEHEN", e);
		}

		InputStream is;
		try {
			URLConnection con = url.openConnection();
			is = con.getInputStream();
		} catch (IOException e) {
			throw new DiscoveryException(e);
		}

		try {
			BufferedReader br = new BufferedReader(new InputStreamReader(is));

			String line;
			while ((line = br.readLine()) != null) {
				HttpHost host = decode(line);
				sonar.discovered(host);
			}
		} catch (IOException e) {
			throw new DiscoveryException(e);
		} finally {
			try {
				is.close();
			} catch (IOException e) {
			}
		}
	}

	protected HttpHost decode(String line) {
		// TODO decode
		return new HttpHost();
	}
}
