package fs.game.core.dc;

import fs.game.core.dc.impl.HttpDiscovery;
import fs.game.core.dc.impl.HttpHost;
import fs.game.core.dc.impl.UdpDiscovery;
import fs.game.core.dc.impl.UdpHost;

public class Factory {
	@SuppressWarnings("unchecked")
	public static <H extends Host> Discovery<H> createDiscovery(Class<H> hostType) {

		// TODO more Generalization
		if (HttpHost.class.isAssignableFrom(hostType)) {
			return (Discovery<H>) new HttpDiscovery();
		} else if (UdpHost.class.isAssignableFrom(hostType)) {
			return (Discovery<H>) new UdpDiscovery();
		} else {
			return null;
		}
	}
}
