package filebookmark.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import filebookmark.Activator;
import filebookmark.model.Bookmark;
import filebookmark.model.Category;
import filebookmark.model.RootCategory;

public class XmlAccessor {

	private static XmlAccessor xmlAccessor;
	private Category rootCategory;
	private String path = null;

	public static XmlAccessor getInstance(){
		if(xmlAccessor == null){
			xmlAccessor = new XmlAccessor();
		}
		
		return xmlAccessor;
	}
	
	private XmlAccessor(){
		path = Activator.getDefault().getStateLocation().toString()
		+ File.separator + "mybookmark.xml"; //$NON-NLS-1$

	}

	/**
	 * XMLǂݍ݁A[gJeSԋpB
	 * 
	 * @return [gJeS
	 */
	protected Category readXml() {

		if(rootCategory != null){
			return rootCategory;
		}
		
		try {
			File file = new File(path);

			if (!file.exists()) {
				file = createXml(path);
			}

			// hLgr_[t@Ng𐶐
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory
					.newInstance();
			// hLgr_[𐶐
			DocumentBuilder builder = dbfactory.newDocumentBuilder();
			Document doc = builder.parse(file);

			// [gvf擾i^OFbookmarkj
			Element root = doc.getDocumentElement();
			rootCategory = new RootCategory(root.getTagName());
			setChildNode(root.getChildNodes(), rootCategory);

		} catch (Exception e) {
			e.printStackTrace();
		}

		return rootCategory;
	}

	/**
	 * XMLXVB
	 */
	protected void writeXml() {
		
		try {

			DocumentBuilderFactory dbfactory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder docbuilder = dbfactory.newDocumentBuilder();
			Document document = docbuilder.newDocument();

			// rootvfƂ bookmarkvf𐶐
			Element root = document.createElement(rootCategory.getName());

			// qvfݒ
			setElement(rootCategory, document, root);			
			document.appendChild(root);

			// DOMIuWFNg𕶎Ƃďo
			TransformerFactory tfactory = TransformerFactory.newInstance();
			Transformer transformer = tfactory.newTransformer();
			File outfile = new File(path);
			transformer.transform(new DOMSource(document), new StreamResult(
					outfile));

		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (TransformerException e) {
			e.printStackTrace();
		}
	}

	/**
	 * [gJeSԋpB
	 * @return [gJeS
	 */
	public Category getRootCategory(){
		if(rootCategory == null){
			readXml();
		}
		return rootCategory;
	}
	
	/**
	 * qvfݒ肷B
	 * @param rootCategory
	 * @param document
	 * @param root
	 */
	private void setElement(Category rootCategory, Document document,
			Element root) {
		
		if(!rootCategory.hasChildren()){
			return;
		}
		
		Bookmark[] bookmarkList = rootCategory.getChildren();
		
		for(Bookmark bookmark : bookmarkList){
		
			if(bookmark.getType() == ElementType.CATEGORY){
				Element childElement = document.createElement("category"); //$NON-NLS-1$
				childElement.setAttribute("name", bookmark.getName()); //$NON-NLS-1$
				root.appendChild(childElement);
				setElement((Category)bookmark, document, childElement);
				
			}else if(bookmark.getType() == ElementType.BOOKMARK){
				Element childFileElement = document.createElement("file"); //$NON-NLS-1$
				childFileElement.setAttribute("name", bookmark.getName()); //$NON-NLS-1$
				childFileElement.setAttribute("path", bookmark.getPath()); //$NON-NLS-1$
				childFileElement.setAttribute("fileType", bookmark.getFileType()); //$NON-NLS-1$
				root.appendChild(childFileElement);
			}
		}
	}

	/**
	 * qvf[gJeSɐݒ肷B
	 * 
	 * @param root
	 *            [gGg
	 * @param parentCategory
	 *            [gJeS
	 */
	private void setChildNode(NodeList nodeList, Category parentCategory) {

		if(nodeList == null){
			return;
		}
		
		for(int i = 0; i < nodeList.getLength(); i++){
			Element element = (Element) nodeList.item(i);
			String name = element.getAttribute("name"); //$NON-NLS-1$
			
			if("category".equals(element.getNodeName())){ //$NON-NLS-1$
				Category childCategory = new Category(name);
				parentCategory.addChild(childCategory);
				
				//ċAIɎqvfZbg
				setChildNode(element.getChildNodes(), childCategory);
				
			}else if("file".equals(element.getNodeName())){ //$NON-NLS-1$
				String path = element.getAttribute("path"); //$NON-NLS-1$
				String fileType = element.getAttribute("fileType"); //$NON-NLS-1$
				parentCategory.addChild(new Bookmark(name, path, fileType));
			}	
		}
	}

	/**
	 * t@C݂Ȃꍇ͐B
	 * 
	 * @param path
	 *            t@CpX
	 * @return t@C
	 * @throws URISyntaxException
	 * @throws IOException
	 * @throws TransformerException 
	 * @throws ParserConfigurationException 
	 */
	private File createXml(String path) throws URISyntaxException, IOException, TransformerException, ParserConfigurationException {

		DocumentBuilderFactory dbfactory = DocumentBuilderFactory
				.newInstance();
		DocumentBuilder docbuilder = dbfactory.newDocumentBuilder(); // DocumentBuilderCX^X
		Document document = docbuilder.newDocument(); // Document̐

		// rootvfƂ bookmarkvf𐶐
		Element root = document.createElement("Bookmark"); // bookmarkm[h쐬 //$NON-NLS-1$
		document.appendChild(root); // m[hDocumentɒǉ

		// DOMIuWFNg𕶎Ƃďo
		TransformerFactory tfactory = TransformerFactory.newInstance();
		Transformer transformer = tfactory.newTransformer();
		File outfile = new File(path);
		transformer.transform(new DOMSource(document), new StreamResult(
				outfile));
		return outfile;

	}

}
