package filebookmark.actions.browser;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserEditor;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;

import filebookmark.Activator;
import filebookmark.preferences.PreferenceConstants;

public class WebBrowserHomeAction implements IEditorActionDelegate {

	private WebBrowserEditor editor;
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		this.editor = (WebBrowserEditor)targetEditor;
	}

	public void run(IAction action) {
	
		IPreferenceStore store = Activator.getDefault().getPreferenceStore();
		String home = store.getString(PreferenceConstants.FILEBOOKMARK_HOME_URL);
		URL url = null;
		try{
			url = new URL(home);
		}catch (MalformedURLException e) {
		}
		
		try{
			WebBrowserEditorInput input 
			= new WebBrowserEditorInput(url, 
					IWorkbenchBrowserSupport.LOCATION_BAR
					| IWorkbenchBrowserSupport.NAVIGATION_BAR
					| IWorkbenchBrowserSupport.AS_EDITOR);
			
			editor.init(editor.getEditorSite(), input);
		} catch (PartInitException e) {
			e.printStackTrace();
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

}
