package filebookmark.actions.browser;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.WebBrowserEditor;

import filebookmark.dialog.AddDialog;
import filebookmark.util.FileBookmarkUtil;

public class WebBrowserAddAction implements IEditorActionDelegate {

	private WebBrowserEditor editor;
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		this.editor = (WebBrowserEditor)targetEditor;
	}

	public void run(IAction action) {
		try {
			Field field = editor.getClass().getDeclaredField("webBrowser"); //$NON-NLS-1$
			field.setAccessible(true);
			BrowserViewer viewer = (BrowserViewer)field.get(editor);
			AddDialog dialog = new AddDialog(Display.getDefault().getActiveShell());
			Map<String, String> fileInfo = new HashMap<String, String>();
			
			fileInfo.put(editor.getTitle(), viewer.getURL());
			dialog.setFileInfo(fileInfo);
			dialog.setUrl(true);
			if(dialog.open() == AddDialog.OK){
				FileBookmarkUtil.refreshView();
			}
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchFieldException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
		
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

}
