package filebookmark.actions;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.browser.WebBrowserEditor;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;

import filebookmark.Activator;
import filebookmark.model.Bookmark;

public class OpenAction implements IObjectActionDelegate {

	private ISelection selection;
	
	public OpenAction(){
		super();
	}
	
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	public void run(IAction action) {
		openEditor();
	}

	public void doubleClickRun(ISelection selection){
		this.selection = selection;
		openEditor();
	}

	/**
	 * GfB^JB
	 *
	 */
	private void openEditor() {

		IWorkbench workbench = Activator.getDefault().getWorkbench();
		IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
		IWorkbenchPage page = window.getActivePage();
	
		IWorkspace workspace = ResourcesPlugin.getWorkspace();
		
		Bookmark bookmark = (Bookmark)((IStructuredSelection)selection).getFirstElement();
		
		if("URL".equals(bookmark.getFileType())){ //$NON-NLS-1$
			URL url = null;
			try {
					url = new URL(bookmark.getPath());
			} catch (MalformedURLException e) {
			}
				WebBrowserEditorInput input 
				= new WebBrowserEditorInput(url, 
						IWorkbenchBrowserSupport.LOCATION_BAR
						| IWorkbenchBrowserSupport.NAVIGATION_BAR
						| IWorkbenchBrowserSupport.AS_EDITOR);
				WebBrowserEditor editor = new WebBrowserEditor();
				editor.open(input);


			return;
		}
		
		IPath path = new Path(bookmark.getPath());
		IFile file = workspace.getRoot().getFile(path);

		if(!file.exists()){
			MessageDialog.openError(
					Display.getDefault().getActiveShell(), 
					Messages.getString("OpenAction.dialog_error"), //$NON-NLS-1$
					Messages.getString("OpenAction.dialog_file_not_found")); //$NON-NLS-1$
			return;
		}
		
		try {
			IDE.openEditor(page, file);
		} catch (PartInitException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

}
