package filebookmark.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

import filebookmark.model.Category;
import filebookmark.util.FileBookmarkUtil;

public class CreateCategoryAction implements IObjectActionDelegate, IViewActionDelegate {

	private ISelection selection;
	
	public CreateCategoryAction(){
		super();
	}
	
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	public void run(IAction action) {
		Category category = (Category)((IStructuredSelection)selection).getFirstElement();
		
		InputDialog newDialog = new InputDialog(Display.getDefault()
				.getActiveShell(), Messages.getString("CreateCategoryAction.dialog_new_category"), Messages.getString("CreateCategoryAction.dialog.name"), "New Category", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				new IInputValidator() {

					public String isValid(String newText) {
						if (newText.length() == 0) {
							return Messages.getString("CreateCategoryAction.dialog_not_category"); //$NON-NLS-1$
						}else if(!FileBookmarkUtil.getRootCategory().exist(newText)){
							return Messages.getString("CreateCategoryAction.dialog_repetition_category"); //$NON-NLS-1$
						}
						return null;
					}

				}) {
			protected Point getInitialSize() {
				return new Point(270, 160);
			}
		};
		
		if (newDialog.open() == Window.OK) {
						 
			//JeS
			Category newCategory = new Category(newDialog.getValue());

			//eJeSɒǉ
			category.addChild(newCategory);
			
			FileBookmarkUtil.refreshView();
			FileBookmarkUtil.writeXml();
		}
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

	public void init(IViewPart view) {
	}

}
