package filebookmark.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;

import filebookmark.dialog.AddDialog;
import filebookmark.util.FileBookmarkUtil;

public class AddAction implements IObjectActionDelegate {

	private ISelection selection;
	
	/**
	 * Constructor for Action1.
	 */
	public AddAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
				
		AddDialog dialog = new AddDialog(Display.getDefault().getActiveShell());

		Map<String, String> fileInfo = new HashMap<String, String>();
		List selectionList = ((IStructuredSelection)selection).toList();
		for(Object obj: selectionList){
		
			String name = ""; //$NON-NLS-1$
			String path = ""; //$NON-NLS-1$
			if(obj instanceof IFile){
				name = ((IFile)obj).getName();
				path = ((IFile)obj).getFullPath().toString();
			}else if(obj instanceof ICompilationUnit){
				name = ((ICompilationUnit)obj).getElementName();
				path = ((ICompilationUnit)obj).getPath().toString();
			}else if(obj instanceof FileEditorInput){
				name = ((FileEditorInput)obj).getName();
				IFile file = (IFile)((FileEditorInput)obj).getAdapter(IFile.class);
				path = file.getFullPath().toString();
			}
			
			fileInfo.put(name, path);
		}
		
		dialog.setFileInfo(fileInfo);
		if(dialog.open() == AddDialog.OK){
			FileBookmarkUtil.refreshView();
		}
	}



	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

}
