/*
 * Decompiled with CFR 0.152.
 */
package filebookmark.util;

import filebookmark.Activator;
import filebookmark.model.Bookmark;
import filebookmark.model.Category;
import filebookmark.model.RootCategory;
import filebookmark.util.ElementType;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlAccessor {
    private static XmlAccessor xmlAccessor;
    private Category rootCategory;
    private String path = String.valueOf(Activator.getDefault().getStateLocation().toString()) + File.separator + "mybookmark.xml";

    public static XmlAccessor getInstance() {
        if (xmlAccessor == null) {
            xmlAccessor = new XmlAccessor();
        }
        return xmlAccessor;
    }

    private XmlAccessor() {
    }

    protected Category readXml() {
        if (this.rootCategory != null) {
            return this.rootCategory;
        }
        try {
            File file = new File(this.path);
            if (!file.exists()) {
                file = this.createXml(this.path);
            }
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(file);
            Element root = doc.getDocumentElement();
            this.rootCategory = new RootCategory(root.getTagName());
            this.setChildNode(root.getChildNodes(), this.rootCategory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.rootCategory;
    }

    protected void writeXml() {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docbuilder = dbfactory.newDocumentBuilder();
            Document document = docbuilder.newDocument();
            Element root = document.createElement(this.rootCategory.getName());
            this.setElement(this.rootCategory, document, root);
            document.appendChild(root);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer();
            File outfile = new File(this.path);
            transformer.transform(new DOMSource(document), new StreamResult(outfile));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public Category getRootCategory() {
        if (this.rootCategory == null) {
            this.readXml();
        }
        return this.rootCategory;
    }

    private void setElement(Category rootCategory, Document document, Element root) {
        Bookmark[] bookmarkList;
        if (!rootCategory.hasChildren()) {
            return;
        }
        Bookmark[] bookmarkArray = bookmarkList = rootCategory.getChildren();
        int n = 0;
        int n2 = bookmarkArray.length;
        while (n < n2) {
            Bookmark bookmark = bookmarkArray[n];
            if (bookmark.getType() == ElementType.CATEGORY) {
                Element childElement = document.createElement("category");
                childElement.setAttribute("name", bookmark.getName());
                root.appendChild(childElement);
                this.setElement((Category)bookmark, document, childElement);
            } else if (bookmark.getType() == ElementType.BOOKMARK) {
                Element childFileElement = document.createElement("file");
                childFileElement.setAttribute("name", bookmark.getName());
                childFileElement.setAttribute("path", bookmark.getPath());
                childFileElement.setAttribute("fileType", bookmark.getFileType());
                root.appendChild(childFileElement);
            }
            ++n;
        }
    }

    private void setChildNode(NodeList nodeList, Category parentCategory) {
        if (nodeList == null) {
            return;
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            String name = element.getAttribute("name");
            if ("category".equals(element.getNodeName())) {
                Category childCategory = new Category(name);
                parentCategory.addChild(childCategory);
                this.setChildNode(element.getChildNodes(), childCategory);
            } else if ("file".equals(element.getNodeName())) {
                String path = element.getAttribute("path");
                String fileType = element.getAttribute("fileType");
                parentCategory.addChild(new Bookmark(name, path, fileType));
            }
            ++i;
        }
    }

    private File createXml(String path) throws URISyntaxException, IOException, TransformerException, ParserConfigurationException {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docbuilder = dbfactory.newDocumentBuilder();
        Document document = docbuilder.newDocument();
        Element root = document.createElement("Bookmark");
        document.appendChild(root);
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer transformer = tfactory.newTransformer();
        File outfile = new File(path);
        transformer.transform(new DOMSource(document), new StreamResult(outfile));
        return outfile;
    }
}

