/*
 * Decompiled with CFR 0.152.
 */
package filebookmark.actions;

import filebookmark.actions.Messages;
import filebookmark.model.Bookmark;
import filebookmark.util.ElementType;
import filebookmark.util.FileBookmarkUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class ChangeAction
implements IObjectActionDelegate,
IViewActionDelegate {
    private ISelection selection;
    private boolean isCategory = false;
    private String oldName = "";
    private Bookmark selectItem;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        this.selectItem = (Bookmark)((IStructuredSelection)this.selection).getFirstElement();
        if (this.selectItem.getType() == ElementType.CATEGORY) {
            this.isCategory = true;
        } else if (this.selectItem.getType() == ElementType.BOOKMARK) {
            this.isCategory = false;
        }
        this.oldName = this.selectItem.getName();
        InputDialog newDialog = new InputDialog(Display.getDefault().getActiveShell(), Messages.getString("ChangeAction.dialog_name_change"), Messages.getString("ChangeAction.dialog_name"), this.oldName, new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() == 0) {
                    return Messages.getString("ChangeAction.dialog_not_input_name");
                }
                if (ChangeAction.this.isCategory && "Bookmark".equals(ChangeAction.this.oldName)) {
                    return Messages.getString("ChangeAction.dialog_not_root_change");
                }
                if (ChangeAction.this.isCategory && !FileBookmarkUtil.getRootCategory().exist(newText) && !ChangeAction.this.selectItem.getName().equals(newText)) {
                    return Messages.getString("ChangeAction.dialog_repetition_category");
                }
                return null;
            }
        }){

            protected Point getInitialSize() {
                return new Point(270, 160);
            }
        };
        if (newDialog.open() == 0) {
            this.selectItem.setName(newDialog.getValue());
            FileBookmarkUtil.writeXml();
            FileBookmarkUtil.refreshView();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void init(IViewPart view) {
    }
}

