/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.form;

import java.io.Serializable;

import jp.sf.fess.entity.FacetInfo;

import org.seasar.struts.annotation.DoubleType;
import org.seasar.struts.annotation.IntegerType;
import org.seasar.struts.annotation.Mask;
import org.seasar.struts.annotation.Maxbytelength;
import org.seasar.struts.annotation.Required;

public class IndexForm implements Serializable {

    private static final long serialVersionUID = 1L;

    @Maxbytelength(maxbytelength = 1000)
    public String query;

    @Maxbytelength(maxbytelength = 1000)
    public String additional;

    @Mask(mask = "-?([0-9]+|[0-9]+\\.[0-9]+)")
    public String latitude;

    @Mask(mask = "-?([0-9]+|[0-9]+\\.[0-9]+)")
    public String longitude;

    @DoubleType
    public String distance;

    @IntegerType
    public String start;

    @IntegerType
    public String pn;

    @IntegerType
    public String num;

    @Maxbytelength(maxbytelength = 1000)
    public String labelTypeValue;

    @Maxbytelength(maxbytelength = 20)
    public String type;

    @Required(target = "go")
    @Maxbytelength(maxbytelength = 4000)
    public String rt;

    @Required(target = "go")
    @Maxbytelength(maxbytelength = 4000)
    public String u;

    @Maxbytelength(maxbytelength = 100)
    public String range;

    @Maxbytelength(maxbytelength = 255)
    public String callback;

    public FacetInfo facet;

}
