/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.FileCrawlingConfigDbm;
import jp.sf.fess.db.cbean.FailureUrlCB;
import jp.sf.fess.db.cbean.FileAuthenticationCB;
import jp.sf.fess.db.cbean.FileConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.FileCrawlingConfigCB;
import jp.sf.fess.db.exbhv.FailureUrlBhv;
import jp.sf.fess.db.exbhv.FileAuthenticationBhv;
import jp.sf.fess.db.exbhv.FileConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exentity.FailureUrl;
import jp.sf.fess.db.exentity.FileAuthentication;
import jp.sf.fess.db.exentity.FileConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.FileCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of FILE_CRAWLING_CONFIG as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, PATHS, INCLUDED_PATHS, EXCLUDED_PATHS, INCLUDED_DOC_PATHS, EXCLUDED_DOC_PATHS, DEPTH, MAX_ACCESS_COUNT, NUM_OF_THREAD, INTERVAL_TIME, BOOST, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     FAILURE_URL, FILE_AUTHENTICATION, FILE_CONFIG_TO_BROWSER_TYPE_MAPPING, FILE_CONFIG_TO_LABEL_TYPE_MAPPING, FILE_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     failureUrlList, fileAuthenticationList, fileConfigToBrowserTypeMappingList, fileConfigToLabelTypeMappingList, fileConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsFileCrawlingConfigBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "FILE_CRAWLING_CONFIG";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return FileCrawlingConfigDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public FileCrawlingConfigDbm getMyDBMeta() {
        return FileCrawlingConfigDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public FileCrawlingConfig newMyEntity() {
        return new FileCrawlingConfig();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public FileCrawlingConfigCB newMyConditionBean() {
        return new FileCrawlingConfigCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * int count = fileCrawlingConfigBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @return The selected count.
     */
    public int selectCount(FileCrawlingConfigCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(FileCrawlingConfigCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * fileCrawlingConfigBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;FileCrawlingConfig&gt;() {
     *     public void handle(FileCrawlingConfig entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @param entityRowHandler The handler of entity row of FileCrawlingConfig. (NotNull)
     */
    public void selectCursor(FileCrawlingConfigCB cb,
            EntityRowHandler<FileCrawlingConfig> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, FileCrawlingConfig.class);
    }

    protected <ENTITY extends FileCrawlingConfig> void doSelectCursor(
            FileCrawlingConfigCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<FileCrawlingConfig>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * FileCrawlingConfig fileCrawlingConfig = fileCrawlingConfigBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (fileCrawlingConfig != null) {
     *     ... = fileCrawlingConfig.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileCrawlingConfig selectEntity(FileCrawlingConfigCB cb) {
        return doSelectEntity(cb, FileCrawlingConfig.class);
    }

    protected <ENTITY extends FileCrawlingConfig> ENTITY doSelectEntity(
            final FileCrawlingConfigCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, FileCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileCrawlingConfigCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * FileCrawlingConfig fileCrawlingConfig = fileCrawlingConfigBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = fileCrawlingConfig.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileCrawlingConfig selectEntityWithDeletedCheck(
            FileCrawlingConfigCB cb) {
        return doSelectEntityWithDeletedCheck(cb, FileCrawlingConfig.class);
    }

    protected <ENTITY extends FileCrawlingConfig> ENTITY doSelectEntityWithDeletedCheck(
            final FileCrawlingConfigCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, FileCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileCrawlingConfigCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileCrawlingConfig selectByPKValue(Long id) {
        return doSelectByPKValue(id, FileCrawlingConfig.class);
    }

    protected <ENTITY extends FileCrawlingConfig> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileCrawlingConfig selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, FileCrawlingConfig.class);
    }

    protected <ENTITY extends FileCrawlingConfig> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private FileCrawlingConfigCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        FileCrawlingConfigCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;FileCrawlingConfig&gt; fileCrawlingConfigList = fileCrawlingConfigBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (FileCrawlingConfig fileCrawlingConfig : fileCrawlingConfigList) {
     *     ... = fileCrawlingConfig.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<FileCrawlingConfig> selectList(FileCrawlingConfigCB cb) {
        return doSelectList(cb, FileCrawlingConfig.class);
    }

    protected <ENTITY extends FileCrawlingConfig> ListResultBean<ENTITY> doSelectList(
            FileCrawlingConfigCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, FileCrawlingConfigCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileCrawlingConfigCB cb, Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;FileCrawlingConfig&gt; page = fileCrawlingConfigBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (FileCrawlingConfig fileCrawlingConfig : page) {
     *     ... = fileCrawlingConfig.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<FileCrawlingConfig> selectPage(
            FileCrawlingConfigCB cb) {
        return doSelectPage(cb, FileCrawlingConfig.class);
    }

    protected <ENTITY extends FileCrawlingConfig> PagingResultBean<ENTITY> doSelectPage(
            FileCrawlingConfigCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, FileCrawlingConfigCB>() {
                    public int callbackSelectCount(FileCrawlingConfigCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            FileCrawlingConfigCB cb, Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * fileCrawlingConfigBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(FileCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<FileCrawlingConfigCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends FileCrawlingConfigCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFailureUrlList(FileCrawlingConfig fileCrawlingConfig,
            ConditionBeanSetupper<FailureUrlCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfig, conditionBeanSetupper);
        loadFailureUrlList(xnewLRLs(fileCrawlingConfig), conditionBeanSetupper);
    }

    /**
     * Load referrer of failureUrlList with the set-upper for condition-bean of referrer.
     * <pre>
     * fileCrawlingConfigBhv.<span style="color: #FD4747">loadFailureUrlList</span>(fileCrawlingConfigList, new ConditionBeanSetupper&lt;FailureUrlCB&gt;() {
     *     public void setup(FailureUrlCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (FileCrawlingConfig fileCrawlingConfig : fileCrawlingConfigList) {
     *     ... = fileCrawlingConfig.<span style="color: #FD4747">getFailureUrlList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setFileConfigId_InScope(pkList);
     * cb.query().addOrderBy_FileConfigId_Asc();
     * </pre>
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFailureUrlList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            ConditionBeanSetupper<FailureUrlCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfigList, conditionBeanSetupper);
        loadFailureUrlList(fileCrawlingConfigList,
                new LoadReferrerOption<FailureUrlCB, FailureUrl>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFailureUrlList(FileCrawlingConfig fileCrawlingConfig,
            LoadReferrerOption<FailureUrlCB, FailureUrl> loadReferrerOption) {
        xassLRArg(fileCrawlingConfig, loadReferrerOption);
        loadFailureUrlList(xnewLRLs(fileCrawlingConfig), loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFailureUrlList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            LoadReferrerOption<FailureUrlCB, FailureUrl> loadReferrerOption) {
        xassLRArg(fileCrawlingConfigList, loadReferrerOption);
        if (fileCrawlingConfigList.isEmpty()) {
            return;
        }
        final FailureUrlBhv referrerBhv = xgetBSFLR().select(
                FailureUrlBhv.class);
        helpLoadReferrerInternally(
                fileCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<FileCrawlingConfig, Long, FailureUrlCB, FailureUrl>() {
                    public Long getPKVal(FileCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(FileCrawlingConfig e,
                            List<FailureUrl> ls) {
                        e.setFailureUrlList(ls);
                    }

                    public FailureUrlCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(FailureUrlCB cb, List<Long> ls) {
                        cb.query().setFileConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(FailureUrlCB cb) {
                        cb.query().addOrderBy_FileConfigId_Asc();
                    }

                    public List<FailureUrl> selRfLs(FailureUrlCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(FailureUrl e) {
                        return e.getFileConfigId();
                    }

                    public void setlcEt(FailureUrl re, FileCrawlingConfig le) {
                        re.setFileCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileAuthenticationList(
            FileCrawlingConfig fileCrawlingConfig,
            ConditionBeanSetupper<FileAuthenticationCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfig, conditionBeanSetupper);
        loadFileAuthenticationList(xnewLRLs(fileCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileAuthenticationList with the set-upper for condition-bean of referrer.
     * <pre>
     * fileCrawlingConfigBhv.<span style="color: #FD4747">loadFileAuthenticationList</span>(fileCrawlingConfigList, new ConditionBeanSetupper&lt;FileAuthenticationCB&gt;() {
     *     public void setup(FileAuthenticationCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (FileCrawlingConfig fileCrawlingConfig : fileCrawlingConfigList) {
     *     ... = fileCrawlingConfig.<span style="color: #FD4747">getFileAuthenticationList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setFileCrawlingConfigId_InScope(pkList);
     * cb.query().addOrderBy_FileCrawlingConfigId_Asc();
     * </pre>
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileAuthenticationList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            ConditionBeanSetupper<FileAuthenticationCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfigList, conditionBeanSetupper);
        loadFileAuthenticationList(
                fileCrawlingConfigList,
                new LoadReferrerOption<FileAuthenticationCB, FileAuthentication>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileAuthenticationList(
            FileCrawlingConfig fileCrawlingConfig,
            LoadReferrerOption<FileAuthenticationCB, FileAuthentication> loadReferrerOption) {
        xassLRArg(fileCrawlingConfig, loadReferrerOption);
        loadFileAuthenticationList(xnewLRLs(fileCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileAuthenticationList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            LoadReferrerOption<FileAuthenticationCB, FileAuthentication> loadReferrerOption) {
        xassLRArg(fileCrawlingConfigList, loadReferrerOption);
        if (fileCrawlingConfigList.isEmpty()) {
            return;
        }
        final FileAuthenticationBhv referrerBhv = xgetBSFLR().select(
                FileAuthenticationBhv.class);
        helpLoadReferrerInternally(
                fileCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<FileCrawlingConfig, Long, FileAuthenticationCB, FileAuthentication>() {
                    public Long getPKVal(FileCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(FileCrawlingConfig e,
                            List<FileAuthentication> ls) {
                        e.setFileAuthenticationList(ls);
                    }

                    public FileAuthenticationCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(FileAuthenticationCB cb, List<Long> ls) {
                        cb.query().setFileCrawlingConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(FileAuthenticationCB cb) {
                        cb.query().addOrderBy_FileCrawlingConfigId_Asc();
                    }

                    public List<FileAuthentication> selRfLs(
                            FileAuthenticationCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(FileAuthentication e) {
                        return e.getFileCrawlingConfigId();
                    }

                    public void setlcEt(FileAuthentication re,
                            FileCrawlingConfig le) {
                        re.setFileCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            FileCrawlingConfig fileCrawlingConfig,
            ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfig, conditionBeanSetupper);
        loadFileConfigToBrowserTypeMappingList(xnewLRLs(fileCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * fileCrawlingConfigBhv.<span style="color: #FD4747">loadFileConfigToBrowserTypeMappingList</span>(fileCrawlingConfigList, new ConditionBeanSetupper&lt;FileConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(FileConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (FileCrawlingConfig fileCrawlingConfig : fileCrawlingConfigList) {
     *     ... = fileCrawlingConfig.<span style="color: #FD4747">getFileConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setFileConfigId_InScope(pkList);
     * cb.query().addOrderBy_FileConfigId_Asc();
     * </pre>
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfigList, conditionBeanSetupper);
        loadFileConfigToBrowserTypeMappingList(
                fileCrawlingConfigList,
                new LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            FileCrawlingConfig fileCrawlingConfig,
            LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(fileCrawlingConfig, loadReferrerOption);
        loadFileConfigToBrowserTypeMappingList(xnewLRLs(fileCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(fileCrawlingConfigList, loadReferrerOption);
        if (fileCrawlingConfigList.isEmpty()) {
            return;
        }
        final FileConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(FileConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                fileCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<FileCrawlingConfig, Long, FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping>() {
                    public Long getPKVal(FileCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(FileCrawlingConfig e,
                            List<FileConfigToBrowserTypeMapping> ls) {
                        e.setFileConfigToBrowserTypeMappingList(ls);
                    }

                    public FileConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(FileConfigToBrowserTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setFileConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(FileConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_FileConfigId_Asc();
                    }

                    public List<FileConfigToBrowserTypeMapping> selRfLs(
                            FileConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(FileConfigToBrowserTypeMapping e) {
                        return e.getFileConfigId();
                    }

                    public void setlcEt(FileConfigToBrowserTypeMapping re,
                            FileCrawlingConfig le) {
                        re.setFileCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            FileCrawlingConfig fileCrawlingConfig,
            ConditionBeanSetupper<FileConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfig, conditionBeanSetupper);
        loadFileConfigToLabelTypeMappingList(xnewLRLs(fileCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileConfigToLabelTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * fileCrawlingConfigBhv.<span style="color: #FD4747">loadFileConfigToLabelTypeMappingList</span>(fileCrawlingConfigList, new ConditionBeanSetupper&lt;FileConfigToLabelTypeMappingCB&gt;() {
     *     public void setup(FileConfigToLabelTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (FileCrawlingConfig fileCrawlingConfig : fileCrawlingConfigList) {
     *     ... = fileCrawlingConfig.<span style="color: #FD4747">getFileConfigToLabelTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setFileConfigId_InScope(pkList);
     * cb.query().addOrderBy_FileConfigId_Asc();
     * </pre>
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            ConditionBeanSetupper<FileConfigToLabelTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfigList, conditionBeanSetupper);
        loadFileConfigToLabelTypeMappingList(
                fileCrawlingConfigList,
                new LoadReferrerOption<FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            FileCrawlingConfig fileCrawlingConfig,
            LoadReferrerOption<FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(fileCrawlingConfig, loadReferrerOption);
        loadFileConfigToLabelTypeMappingList(xnewLRLs(fileCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToLabelTypeMappingList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            LoadReferrerOption<FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping> loadReferrerOption) {
        xassLRArg(fileCrawlingConfigList, loadReferrerOption);
        if (fileCrawlingConfigList.isEmpty()) {
            return;
        }
        final FileConfigToLabelTypeMappingBhv referrerBhv = xgetBSFLR().select(
                FileConfigToLabelTypeMappingBhv.class);
        helpLoadReferrerInternally(
                fileCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<FileCrawlingConfig, Long, FileConfigToLabelTypeMappingCB, FileConfigToLabelTypeMapping>() {
                    public Long getPKVal(FileCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(FileCrawlingConfig e,
                            List<FileConfigToLabelTypeMapping> ls) {
                        e.setFileConfigToLabelTypeMappingList(ls);
                    }

                    public FileConfigToLabelTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(FileConfigToLabelTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setFileConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(FileConfigToLabelTypeMappingCB cb) {
                        cb.query().addOrderBy_FileConfigId_Asc();
                    }

                    public List<FileConfigToLabelTypeMapping> selRfLs(
                            FileConfigToLabelTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(FileConfigToLabelTypeMapping e) {
                        return e.getFileConfigId();
                    }

                    public void setlcEt(FileConfigToLabelTypeMapping re,
                            FileCrawlingConfig le) {
                        re.setFileCrawlingConfig(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            FileCrawlingConfig fileCrawlingConfig,
            ConditionBeanSetupper<FileConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfig, conditionBeanSetupper);
        loadFileConfigToRoleTypeMappingList(xnewLRLs(fileCrawlingConfig),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileConfigToRoleTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * fileCrawlingConfigBhv.<span style="color: #FD4747">loadFileConfigToRoleTypeMappingList</span>(fileCrawlingConfigList, new ConditionBeanSetupper&lt;FileConfigToRoleTypeMappingCB&gt;() {
     *     public void setup(FileConfigToRoleTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (FileCrawlingConfig fileCrawlingConfig : fileCrawlingConfigList) {
     *     ... = fileCrawlingConfig.<span style="color: #FD4747">getFileConfigToRoleTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setFileConfigId_InScope(pkList);
     * cb.query().addOrderBy_FileConfigId_Asc();
     * </pre>
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            ConditionBeanSetupper<FileConfigToRoleTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(fileCrawlingConfigList, conditionBeanSetupper);
        loadFileConfigToRoleTypeMappingList(
                fileCrawlingConfigList,
                new LoadReferrerOption<FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param fileCrawlingConfig The entity of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            FileCrawlingConfig fileCrawlingConfig,
            LoadReferrerOption<FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(fileCrawlingConfig, loadReferrerOption);
        loadFileConfigToRoleTypeMappingList(xnewLRLs(fileCrawlingConfig),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param fileCrawlingConfigList The entity list of fileCrawlingConfig. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToRoleTypeMappingList(
            List<FileCrawlingConfig> fileCrawlingConfigList,
            LoadReferrerOption<FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping> loadReferrerOption) {
        xassLRArg(fileCrawlingConfigList, loadReferrerOption);
        if (fileCrawlingConfigList.isEmpty()) {
            return;
        }
        final FileConfigToRoleTypeMappingBhv referrerBhv = xgetBSFLR().select(
                FileConfigToRoleTypeMappingBhv.class);
        helpLoadReferrerInternally(
                fileCrawlingConfigList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<FileCrawlingConfig, Long, FileConfigToRoleTypeMappingCB, FileConfigToRoleTypeMapping>() {
                    public Long getPKVal(FileCrawlingConfig e) {
                        return e.getId();
                    }

                    public void setRfLs(FileCrawlingConfig e,
                            List<FileConfigToRoleTypeMapping> ls) {
                        e.setFileConfigToRoleTypeMappingList(ls);
                    }

                    public FileConfigToRoleTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(FileConfigToRoleTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setFileConfigId_InScope(ls);
                    }

                    public void qyOdFKAsc(FileConfigToRoleTypeMappingCB cb) {
                        cb.query().addOrderBy_FileConfigId_Asc();
                    }

                    public List<FileConfigToRoleTypeMapping> selRfLs(
                            FileConfigToRoleTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(FileConfigToRoleTypeMapping e) {
                        return e.getFileConfigId();
                    }

                    public void setlcEt(FileConfigToRoleTypeMapping re,
                            FileCrawlingConfig le) {
                        re.setFileCrawlingConfig(le);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * FileCrawlingConfig fileCrawlingConfig = new FileCrawlingConfig();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * fileCrawlingConfig.setFoo...(value);
     * fileCrawlingConfig.setBar...(value);
     * fileCrawlingConfigBhv.<span style="color: #FD4747">insert</span>(fileCrawlingConfig);
     * ... = fileCrawlingConfig.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param fileCrawlingConfig The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(FileCrawlingConfig fileCrawlingConfig) {
        assertEntityNotNull(fileCrawlingConfig);
        delegateInsert(fileCrawlingConfig);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileCrawlingConfig fileCrawlingConfig = new FileCrawlingConfig();
     * fileCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     fileCrawlingConfigBhv.<span style="color: #FD4747">update</span>(fileCrawlingConfig);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param fileCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final FileCrawlingConfig fileCrawlingConfig) {
        helpUpdateInternally(fileCrawlingConfig,
                new InternalUpdateCallback<FileCrawlingConfig>() {
                    public int callbackDelegateUpdate(FileCrawlingConfig entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * FileCrawlingConfig fileCrawlingConfig = new FileCrawlingConfig();
     * fileCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileCrawlingConfig.setVersionNo(value);</span>
     * fileCrawlingConfigBhv.<span style="color: #FD4747">updateNonstrict</span>(fileCrawlingConfig);
     * </pre>
     * @param fileCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final FileCrawlingConfig fileCrawlingConfig) {
        helpUpdateNonstrictInternally(fileCrawlingConfig,
                new InternalUpdateNonstrictCallback<FileCrawlingConfig>() {
                    public int callbackDelegateUpdateNonstrict(
                            FileCrawlingConfig entity) {
                        return delegateUpdateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        updateNonstrict(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param fileCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final FileCrawlingConfig fileCrawlingConfig) {
        helpInsertOrUpdateInternally(
                fileCrawlingConfig,
                new InternalInsertOrUpdateCallback<FileCrawlingConfig, FileCrawlingConfigCB>() {
                    public void callbackInsert(FileCrawlingConfig entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(FileCrawlingConfig entity) {
                        update(entity);
                    }

                    public FileCrawlingConfigCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(FileCrawlingConfigCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param fileCrawlingConfig The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(FileCrawlingConfig fileCrawlingConfig) {
        helpInsertOrUpdateInternally(
                fileCrawlingConfig,
                new InternalInsertOrUpdateNonstrictCallback<FileCrawlingConfig>() {
                    public void callbackInsert(FileCrawlingConfig entity) {
                        insert(entity);
                    }

                    public void callbackUpdateNonstrict(
                            FileCrawlingConfig entity) {
                        updateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdateNonstrict(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileCrawlingConfig fileCrawlingConfig = new FileCrawlingConfig();
     * fileCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     fileCrawlingConfigBhv.<span style="color: #FD4747">delete</span>(fileCrawlingConfig);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param fileCrawlingConfig The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(FileCrawlingConfig fileCrawlingConfig) {
        helpDeleteInternally(fileCrawlingConfig,
                new InternalDeleteCallback<FileCrawlingConfig>() {
                    public int callbackDelegateDelete(FileCrawlingConfig entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * FileCrawlingConfig fileCrawlingConfig = new FileCrawlingConfig();
     * fileCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileCrawlingConfig.setVersionNo(value);</span>
     * fileCrawlingConfigBhv.<span style="color: #FD4747">deleteNonstrict</span>(fileCrawlingConfig);
     * </pre>
     * @param fileCrawlingConfig Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(FileCrawlingConfig fileCrawlingConfig) {
        helpDeleteNonstrictInternally(fileCrawlingConfig,
                new InternalDeleteNonstrictCallback<FileCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            FileCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * FileCrawlingConfig fileCrawlingConfig = new FileCrawlingConfig();
     * fileCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileCrawlingConfig.setVersionNo(value);</span>
     * fileCrawlingConfigBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(fileCrawlingConfig);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param fileCrawlingConfig Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(
            FileCrawlingConfig fileCrawlingConfig) {
        helpDeleteNonstrictIgnoreDeletedInternally(
                fileCrawlingConfig,
                new InternalDeleteNonstrictIgnoreDeletedCallback<FileCrawlingConfig>() {
                    public int callbackDelegateDeleteNonstrict(
                            FileCrawlingConfig entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<FileCrawlingConfig> fileCrawlingConfigList) {
        assertObjectNotNull("fileCrawlingConfigList", fileCrawlingConfigList);
        return delegateInsertList(fileCrawlingConfigList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<FileCrawlingConfig> fileCrawlingConfigList) {
        assertObjectNotNull("fileCrawlingConfigList", fileCrawlingConfigList);
        return delegateUpdateList(fileCrawlingConfigList);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<FileCrawlingConfig> fileCrawlingConfigList) {
        assertObjectNotNull("fileCrawlingConfigList", fileCrawlingConfigList);
        return delegateUpdateListNonstrict(fileCrawlingConfigList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<FileCrawlingConfig> fileCrawlingConfigList) {
        assertObjectNotNull("fileCrawlingConfigList", fileCrawlingConfigList);
        return delegateDeleteList(fileCrawlingConfigList);
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileCrawlingConfigList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(
            List<FileCrawlingConfig> fileCrawlingConfigList) {
        assertObjectNotNull("fileCrawlingConfigList", fileCrawlingConfigList);
        return delegateDeleteListNonstrict(fileCrawlingConfigList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * FileCrawlingConfig fileCrawlingConfig = new FileCrawlingConfig();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//fileCrawlingConfig.setPK...(value);</span>
     * fileCrawlingConfig.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileCrawlingConfig.setVersionNo(value);</span>
     * FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * fileCrawlingConfigBhv.<span style="color: #FD4747">queryUpdate</span>(fileCrawlingConfig, cb);
     * </pre>
     * @param fileCrawlingConfig The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(FileCrawlingConfig fileCrawlingConfig,
            FileCrawlingConfigCB cb) {
        return delegateQueryUpdate(fileCrawlingConfig, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * fileCrawlingConfigBhv.<span style="color: #FD4747">queryDelete</span>(fileCrawlingConfig, cb);
     * </pre>
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(FileCrawlingConfigCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileCrawlingConfig fileCrawlingConfig = new FileCrawlingConfig();
     * fileCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileCrawlingConfig.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;FileCrawlingConfigCB&gt; option = new UpdateOption&lt;FileCrawlingConfigCB&gt;();
     *     option.self(new SpecifyQuery&lt;FileCrawlingConfigCB&gt;() {
     *         public void specify(FileCrawlingConfigCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     fileCrawlingConfigBhv.<span style="color: #FD4747">varyingUpdate</span>(fileCrawlingConfig, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param fileCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(FileCrawlingConfig fileCrawlingConfig,
            final UpdateOption<FileCrawlingConfigCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(fileCrawlingConfig,
                new InternalUpdateCallback<FileCrawlingConfig>() {
                    public int callbackDelegateUpdate(FileCrawlingConfig entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * FileCrawlingConfig fileCrawlingConfig = new FileCrawlingConfig();
     * fileCrawlingConfig.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileCrawlingConfig.setVersionNo(value);</span>
     * UpdateOption&lt;FileCrawlingConfigCB&gt; option = new UpdateOption&lt;FileCrawlingConfigCB&gt;();
     * option.self(new SpecifyQuery&lt;FileCrawlingConfigCB&gt;() {
     *     public void specify(FileCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * fileCrawlingConfigBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(fileCrawlingConfig, option);
     * </pre>
     * @param fileCrawlingConfig The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(FileCrawlingConfig fileCrawlingConfig,
            final UpdateOption<FileCrawlingConfigCB> option) {
        processVaryingUpdate(option);
        helpUpdateNonstrictInternally(fileCrawlingConfig,
                new InternalUpdateNonstrictCallback<FileCrawlingConfig>() {
                    public int callbackDelegateUpdateNonstrict(
                            FileCrawlingConfig entity) {
                        return delegateVaryingUpdateNonstrict(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * FileCrawlingConfig fileCrawlingConfig = new FileCrawlingConfig();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//fileCrawlingConfig.setPK...(value);</span>
     * fileCrawlingConfig.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileCrawlingConfig.setVersionNo(value);</span>
     * FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;FileCrawlingConfigCB&gt; option = new UpdateOption&lt;FileCrawlingConfigCB&gt;();
     * option.self(new SpecifyQuery&lt;FileCrawlingConfigCB&gt;() {
     *     public void specify(FileCrawlingConfigCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * fileCrawlingConfigBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(fileCrawlingConfig, cb, option);
     * </pre>
     * @param fileCrawlingConfig The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of FileCrawlingConfig. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(FileCrawlingConfig fileCrawlingConfig,
            FileCrawlingConfigCB cb,
            final UpdateOption<FileCrawlingConfigCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(fileCrawlingConfig, cb, option);
    }

    protected void processVaryingUpdate(
            UpdateOption<FileCrawlingConfigCB> option) {
        assertUpdateOptionNotNull(option);
        FileCrawlingConfigCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(FileCrawlingConfigCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends FileCrawlingConfig> void delegateSelectCursor(
            FileCrawlingConfigCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends FileCrawlingConfig> List<ENTITY> delegateSelectList(
            FileCrawlingConfigCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(FileCrawlingConfig e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(FileCrawlingConfig e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int delegateUpdateNonstrict(FileCrawlingConfig e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(FileCrawlingConfig e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int delegateDeleteNonstrict(FileCrawlingConfig e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<FileCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<FileCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateUpdateListNonstrict(List<FileCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    protected int[] delegateDeleteList(List<FileCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int[] delegateDeleteListNonstrict(List<FileCrawlingConfig> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    protected int delegateQueryUpdate(FileCrawlingConfig e,
            FileCrawlingConfigCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(FileCrawlingConfigCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(FileCrawlingConfig e,
            UpdateOption<FileCrawlingConfigCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateEntityCommand(e, op));
    }

    protected int delegateVaryingUpdateNonstrict(FileCrawlingConfig e,
            UpdateOption<FileCrawlingConfigCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(FileCrawlingConfig e,
            FileCrawlingConfigCB cb, UpdateOption<FileCrawlingConfigCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected FileCrawlingConfig downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, FileCrawlingConfig.class);
    }

    protected FileCrawlingConfigCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                FileCrawlingConfigCB.class);
    }
}
