/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.sf.fess.Constants;
import jp.sf.fess.crud.CrudMessageException;
import jp.sf.fess.crud.service.BsWebCrawlingConfigService;
import jp.sf.fess.db.cbean.WebConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.WebCrawlingConfigCB;
import jp.sf.fess.db.exbhv.WebConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exentity.CrawlingConfig;
import jp.sf.fess.db.exentity.WebConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.WebCrawlingConfig;
import jp.sf.fess.pager.WebCrawlingConfigPager;

import org.seasar.dbflute.bhv.ConditionBeanSetupper;

public class WebCrawlingConfigService extends BsWebCrawlingConfigService
        implements Serializable {

    private static final long serialVersionUID = 1L;

    @Resource
    protected WebConfigToBrowserTypeMappingBhv webConfigToBrowserTypeMappingBhv;

    public List<WebCrawlingConfig> getAllWebCrawlingConfigList() {
        WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
        cb.query().setDeletedBy_IsNull();
        cb.query().setAvailable_Equal(Constants.T);
        List<WebCrawlingConfig> list = webCrawlingConfigBhv.selectList(cb);
        final ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB> setupper = new ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB>() {
            public void setup(WebConfigToBrowserTypeMappingCB cb) {
                cb.setupSelect_BrowserType();
                cb.query().queryBrowserType().setDeletedBy_IsNull();
                cb.query().queryBrowserType().addOrderBy_SortOrder_Asc();
            }

        };
        webCrawlingConfigBhv.loadWebConfigToBrowserTypeMappingList(list,
                setupper);
        return list;
    }

    public WebCrawlingConfig getWebCrawlingConfig(Map<String, String> keys) {
        WebCrawlingConfig webCrawlingConfig = super.getWebCrawlingConfig(keys);

        if (webCrawlingConfig != null) {
            WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
            cb.query().setWebConfigId_Equal(webCrawlingConfig.getId());
            cb.query().queryBrowserType().setDeletedBy_IsNull();
            cb.query().queryWebCrawlingConfig().setDeletedBy_IsNull();
            List<WebConfigToBrowserTypeMapping> list = webConfigToBrowserTypeMappingBhv
                    .selectList(cb);
            if (!list.isEmpty()) {
                List<String> browserTypeIds = new ArrayList<String>(list.size());
                for (WebConfigToBrowserTypeMapping mapping : list) {
                    browserTypeIds.add(Long
                            .toString(mapping.getBrowserTypeId()));
                }
                webCrawlingConfig.setBrowserTypeIds(browserTypeIds
                        .toArray(new String[browserTypeIds.size()]));
            }
        }

        return webCrawlingConfig;
    }

    public void store(WebCrawlingConfig webCrawlingConfig)
            throws CrudMessageException {
        boolean isNew = webCrawlingConfig.getId() == null;
        String[] ids = webCrawlingConfig.getBrowserTypeIds();
        super.store(webCrawlingConfig);
        Long webConfigId = webCrawlingConfig.getId();
        if (isNew) {
            // Insert
            List<WebConfigToBrowserTypeMapping> list = new ArrayList<WebConfigToBrowserTypeMapping>();
            for (String id : ids) {
                WebConfigToBrowserTypeMapping mapping = new WebConfigToBrowserTypeMapping();
                mapping.setWebConfigId(webConfigId);
                mapping.setBrowserTypeId(Long.parseLong(id));
                list.add(mapping);
            }
            webConfigToBrowserTypeMappingBhv.batchInsert(list);
        } else {
            // Update
            WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
            cb.query().setWebConfigId_Equal(webConfigId);
            List<WebConfigToBrowserTypeMapping> list = webConfigToBrowserTypeMappingBhv
                    .selectList(cb);
            List<WebConfigToBrowserTypeMapping> newList = new ArrayList<WebConfigToBrowserTypeMapping>();
            List<WebConfigToBrowserTypeMapping> matchedList = new ArrayList<WebConfigToBrowserTypeMapping>();
            for (String id : ids) {
                Long browserTypeId = Long.parseLong(id);
                boolean exist = false;
                for (WebConfigToBrowserTypeMapping mapping : list) {
                    if (mapping.getBrowserTypeId().equals(browserTypeId)) {
                        exist = true;
                        matchedList.add(mapping);
                        break;
                    }
                }
                if (!exist) {
                    // new
                    WebConfigToBrowserTypeMapping mapping = new WebConfigToBrowserTypeMapping();
                    mapping.setWebConfigId(webConfigId);
                    mapping.setBrowserTypeId(Long.parseLong(id));
                    newList.add(mapping);
                }
            }
            list.removeAll(matchedList);
            webConfigToBrowserTypeMappingBhv.batchInsert(newList);
            webConfigToBrowserTypeMappingBhv.batchDelete(list);
        }
    }

    protected void setupListCondition(WebCrawlingConfigCB cb,
            WebCrawlingConfigPager webCrawlingConfigPager) {
        super.setupListCondition(cb, webCrawlingConfigPager);

        // setup condition
        cb.query().setDeletedBy_IsNull();
        cb.query().addOrderBy_SortOrder_Asc();
        cb.query().addOrderBy_Name_Asc();

        // search

    }

    protected void setupEntityCondition(WebCrawlingConfigCB cb,
            Map<String, String> keys) {
        super.setupEntityCondition(cb, keys);

        // setup condition
        cb.query().setDeletedBy_IsNull();

    }

    protected void setupStoreCondition(CrawlingConfig webCrawlingConfig) {
        super.setupStoreCondition(webCrawlingConfig);

        // setup condition

    }

    protected void setupDeleteCondition(CrawlingConfig webCrawlingConfig) {
        super.setupDeleteCondition(webCrawlingConfig);

        // setup condition

    }

}
