package jp.sf.fess.crud.service;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.sf.fess.crud.CommonConstants;
import jp.sf.fess.crud.CrudMessageException;
import jp.sf.fess.db.cbean.OverlappingHostCB;
import jp.sf.fess.db.exbhv.OverlappingHostBhv;
import jp.sf.fess.db.exentity.OverlappingHost;
import jp.sf.fess.pager.OverlappingHostPager;

import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.framework.beans.util.Beans;

public abstract class BsOverlappingHostService {

    @Resource
    protected OverlappingHostBhv overlappingHostBhv;

    public BsOverlappingHostService() {
        super();
    }

    public List<OverlappingHost> getOverlappingHostList(
            OverlappingHostPager overlappingHostPager) {

        OverlappingHostCB cb = new OverlappingHostCB();

        cb.fetchFirst(overlappingHostPager.getPageSize());
        cb.fetchPage(overlappingHostPager.getCurrentPageNumber());

        setupListCondition(cb, overlappingHostPager);

        PagingResultBean<OverlappingHost> overlappingHostList = overlappingHostBhv
                .selectPage(cb);

        // update pager
        Beans.copy(overlappingHostList, overlappingHostPager).includes(
                CommonConstants.PAGER_CONVERSION_RULE).execute();
        overlappingHostList.setPageRangeSize(5);
        overlappingHostPager.setPageNumberList(overlappingHostList.pageRange()
                .createPageNumberList());

        return overlappingHostList;
    }

    public OverlappingHost getOverlappingHost(Map<String, String> keys) {
        OverlappingHostCB cb = new OverlappingHostCB();

        cb.query().setId_Equal(Long.parseLong(keys.get("id")));
        // TODO Long, Integer, String supported only.

        setupEntityCondition(cb, keys);

        OverlappingHost overlappingHost = overlappingHostBhv.selectEntity(cb);
        if (overlappingHost == null) {
            // TODO exception?
            return null;
        }

        return overlappingHost;
    }

    public void store(OverlappingHost overlappingHost)
            throws CrudMessageException {
        setupStoreCondition(overlappingHost);

        overlappingHostBhv.insertOrUpdate(overlappingHost);

    }

    public void delete(OverlappingHost overlappingHost)
            throws CrudMessageException {
        setupDeleteCondition(overlappingHost);

        overlappingHostBhv.delete(overlappingHost);

    }

    protected void setupListCondition(OverlappingHostCB cb,
            OverlappingHostPager overlappingHostPager) {

        if (overlappingHostPager.id != null) {
            cb.query().setId_Equal(Long.parseLong(overlappingHostPager.id));
        }
        // TODO Long, Integer, String supported only.
    }

    protected void setupEntityCondition(OverlappingHostCB cb,
            Map<String, String> keys) {
    }

    protected void setupStoreCondition(OverlappingHost overlappingHost) {
    }

    protected void setupDeleteCondition(OverlappingHost overlappingHost) {
    }
}