/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.CrawlingSessionDbm;
import jp.sf.fess.db.cbean.CrawlingSessionCB;
import jp.sf.fess.db.cbean.CrawlingSessionInfoCB;
import jp.sf.fess.db.exbhv.CrawlingSessionInfoBhv;
import jp.sf.fess.db.exentity.CrawlingSession;
import jp.sf.fess.db.exentity.CrawlingSessionInfo;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of CRAWLING_SESSION as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, SESSION_ID, CREATED_TIME
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     CRAWLING_SESSION_INFO
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     crawlingSessionInfoList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsCrawlingSessionBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "CRAWLING_SESSION";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return CrawlingSessionDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public CrawlingSessionDbm getMyDBMeta() {
        return CrawlingSessionDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public CrawlingSession newMyEntity() {
        return new CrawlingSession();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public CrawlingSessionCB newMyConditionBean() {
        return new CrawlingSessionCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * CrawlingSessionCB cb = new CrawlingSessionCB();
     * cb.query().setFoo...(value);
     * int count = crawlingSessionBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @return The selected count.
     */
    public int selectCount(CrawlingSessionCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(CrawlingSessionCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * CrawlingSessionCB cb = new CrawlingSessionCB();
     * cb.query().setFoo...(value);
     * crawlingSessionBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;CrawlingSession&gt;() {
     *     public void handle(CrawlingSession entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @param entityRowHandler The handler of entity row of CrawlingSession. (NotNull)
     */
    public void selectCursor(CrawlingSessionCB cb,
            EntityRowHandler<CrawlingSession> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, CrawlingSession.class);
    }

    protected <ENTITY extends CrawlingSession> void doSelectCursor(
            CrawlingSessionCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<CrawlingSession>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * CrawlingSessionCB cb = new CrawlingSessionCB();
     * cb.query().setFoo...(value);
     * CrawlingSession crawlingSession = crawlingSessionBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (crawlingSession != null) {
     *     ... = crawlingSession.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public CrawlingSession selectEntity(CrawlingSessionCB cb) {
        return doSelectEntity(cb, CrawlingSession.class);
    }

    protected <ENTITY extends CrawlingSession> ENTITY doSelectEntity(
            final CrawlingSessionCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, CrawlingSessionCB>() {
                    public List<ENTITY> callbackSelectList(CrawlingSessionCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * CrawlingSessionCB cb = new CrawlingSessionCB();
     * cb.query().setFoo...(value);
     * CrawlingSession crawlingSession = crawlingSessionBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = crawlingSession.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public CrawlingSession selectEntityWithDeletedCheck(CrawlingSessionCB cb) {
        return doSelectEntityWithDeletedCheck(cb, CrawlingSession.class);
    }

    protected <ENTITY extends CrawlingSession> ENTITY doSelectEntityWithDeletedCheck(
            final CrawlingSessionCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, CrawlingSessionCB>() {
                    public List<ENTITY> callbackSelectList(CrawlingSessionCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public CrawlingSession selectByPKValue(Long id) {
        return doSelectByPKValue(id, CrawlingSession.class);
    }

    protected <ENTITY extends CrawlingSession> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public CrawlingSession selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, CrawlingSession.class);
    }

    protected <ENTITY extends CrawlingSession> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private CrawlingSessionCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        CrawlingSessionCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * CrawlingSessionCB cb = new CrawlingSessionCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;CrawlingSession&gt; crawlingSessionList = crawlingSessionBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (CrawlingSession crawlingSession : crawlingSessionList) {
     *     ... = crawlingSession.get...();
     * }
     * </pre>
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<CrawlingSession> selectList(CrawlingSessionCB cb) {
        return doSelectList(cb, CrawlingSession.class);
    }

    protected <ENTITY extends CrawlingSession> ListResultBean<ENTITY> doSelectList(
            CrawlingSessionCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, CrawlingSessionCB>() {
                    public List<ENTITY> callbackSelectList(
                            CrawlingSessionCB cb, Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * CrawlingSessionCB cb = new CrawlingSessionCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;CrawlingSession&gt; page = crawlingSessionBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (CrawlingSession crawlingSession : page) {
     *     ... = crawlingSession.get...();
     * }
     * </pre>
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<CrawlingSession> selectPage(CrawlingSessionCB cb) {
        return doSelectPage(cb, CrawlingSession.class);
    }

    protected <ENTITY extends CrawlingSession> PagingResultBean<ENTITY> doSelectPage(
            CrawlingSessionCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, CrawlingSessionCB>() {
                    public int callbackSelectCount(CrawlingSessionCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            CrawlingSessionCB cb, Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * crawlingSessionBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(CrawlingSessionCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<CrawlingSessionCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends CrawlingSessionCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param crawlingSession The entity of crawlingSession. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadCrawlingSessionInfoList(CrawlingSession crawlingSession,
            ConditionBeanSetupper<CrawlingSessionInfoCB> conditionBeanSetupper) {
        xassLRArg(crawlingSession, conditionBeanSetupper);
        loadCrawlingSessionInfoList(xnewLRLs(crawlingSession),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of crawlingSessionInfoList with the set-upper for condition-bean of referrer.
     * <pre>
     * crawlingSessionBhv.<span style="color: #FD4747">loadCrawlingSessionInfoList</span>(crawlingSessionList, new ConditionBeanSetupper&lt;CrawlingSessionInfoCB&gt;() {
     *     public void setup(CrawlingSessionInfoCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (CrawlingSession crawlingSession : crawlingSessionList) {
     *     ... = crawlingSession.<span style="color: #FD4747">getCrawlingSessionInfoList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setCrawlingSessionId_InScope(pkList);
     * cb.query().addOrderBy_CrawlingSessionId_Asc();
     * </pre>
     * @param crawlingSessionList The entity list of crawlingSession. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadCrawlingSessionInfoList(
            List<CrawlingSession> crawlingSessionList,
            ConditionBeanSetupper<CrawlingSessionInfoCB> conditionBeanSetupper) {
        xassLRArg(crawlingSessionList, conditionBeanSetupper);
        loadCrawlingSessionInfoList(
                crawlingSessionList,
                new LoadReferrerOption<CrawlingSessionInfoCB, CrawlingSessionInfo>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param crawlingSession The entity of crawlingSession. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadCrawlingSessionInfoList(
            CrawlingSession crawlingSession,
            LoadReferrerOption<CrawlingSessionInfoCB, CrawlingSessionInfo> loadReferrerOption) {
        xassLRArg(crawlingSession, loadReferrerOption);
        loadCrawlingSessionInfoList(xnewLRLs(crawlingSession),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param crawlingSessionList The entity list of crawlingSession. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadCrawlingSessionInfoList(
            List<CrawlingSession> crawlingSessionList,
            LoadReferrerOption<CrawlingSessionInfoCB, CrawlingSessionInfo> loadReferrerOption) {
        xassLRArg(crawlingSessionList, loadReferrerOption);
        if (crawlingSessionList.isEmpty()) {
            return;
        }
        final CrawlingSessionInfoBhv referrerBhv = xgetBSFLR().select(
                CrawlingSessionInfoBhv.class);
        helpLoadReferrerInternally(
                crawlingSessionList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<CrawlingSession, Long, CrawlingSessionInfoCB, CrawlingSessionInfo>() {
                    public Long getPKVal(CrawlingSession e) {
                        return e.getId();
                    }

                    public void setRfLs(CrawlingSession e,
                            List<CrawlingSessionInfo> ls) {
                        e.setCrawlingSessionInfoList(ls);
                    }

                    public CrawlingSessionInfoCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(CrawlingSessionInfoCB cb, List<Long> ls) {
                        cb.query().setCrawlingSessionId_InScope(ls);
                    }

                    public void qyOdFKAsc(CrawlingSessionInfoCB cb) {
                        cb.query().addOrderBy_CrawlingSessionId_Asc();
                    }

                    public List<CrawlingSessionInfo> selRfLs(
                            CrawlingSessionInfoCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(CrawlingSessionInfo e) {
                        return e.getCrawlingSessionId();
                    }

                    public void setlcEt(CrawlingSessionInfo re,
                            CrawlingSession le) {
                        re.setCrawlingSession(le);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * CrawlingSession crawlingSession = new CrawlingSession();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * crawlingSession.setFoo...(value);
     * crawlingSession.setBar...(value);
     * crawlingSessionBhv.<span style="color: #FD4747">insert</span>(crawlingSession);
     * ... = crawlingSession.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param crawlingSession The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(CrawlingSession crawlingSession) {
        assertEntityNotNull(crawlingSession);
        delegateInsert(crawlingSession);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * CrawlingSession crawlingSession = new CrawlingSession();
     * crawlingSession.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * crawlingSession.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * crawlingSession.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     crawlingSessionBhv.<span style="color: #FD4747">update</span>(crawlingSession);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param crawlingSession The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final CrawlingSession crawlingSession) {
        helpUpdateInternally(crawlingSession,
                new InternalUpdateCallback<CrawlingSession>() {
                    public int callbackDelegateUpdate(CrawlingSession entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param crawlingSession The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final CrawlingSession crawlingSession) {
        helpInsertOrUpdateInternally(
                crawlingSession,
                new InternalInsertOrUpdateCallback<CrawlingSession, CrawlingSessionCB>() {
                    public void callbackInsert(CrawlingSession entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(CrawlingSession entity) {
                        update(entity);
                    }

                    public CrawlingSessionCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(CrawlingSessionCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * CrawlingSession crawlingSession = new CrawlingSession();
     * crawlingSession.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * crawlingSession.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     crawlingSessionBhv.<span style="color: #FD4747">delete</span>(crawlingSession);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param crawlingSession The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(CrawlingSession crawlingSession) {
        helpDeleteInternally(crawlingSession,
                new InternalDeleteCallback<CrawlingSession>() {
                    public int callbackDelegateDelete(CrawlingSession entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param crawlingSessionList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<CrawlingSession> crawlingSessionList) {
        assertObjectNotNull("crawlingSessionList", crawlingSessionList);
        return delegateInsertList(crawlingSessionList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param crawlingSessionList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(List<CrawlingSession> crawlingSessionList) {
        assertObjectNotNull("crawlingSessionList", crawlingSessionList);
        return delegateUpdateList(crawlingSessionList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param crawlingSessionList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(List<CrawlingSession> crawlingSessionList) {
        assertObjectNotNull("crawlingSessionList", crawlingSessionList);
        return delegateDeleteList(crawlingSessionList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * CrawlingSession crawlingSession = new CrawlingSession();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//crawlingSession.setPK...(value);</span>
     * crawlingSession.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//crawlingSession.setVersionNo(value);</span>
     * CrawlingSessionCB cb = new CrawlingSessionCB();
     * cb.query().setFoo...(value);
     * crawlingSessionBhv.<span style="color: #FD4747">queryUpdate</span>(crawlingSession, cb);
     * </pre>
     * @param crawlingSession The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(CrawlingSession crawlingSession, CrawlingSessionCB cb) {
        return delegateQueryUpdate(crawlingSession, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * CrawlingSessionCB cb = new CrawlingSessionCB();
     * cb.query().setFoo...(value);
     * crawlingSessionBhv.<span style="color: #FD4747">queryDelete</span>(crawlingSession, cb);
     * </pre>
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(CrawlingSessionCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * CrawlingSession crawlingSession = new CrawlingSession();
     * crawlingSession.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * crawlingSession.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * crawlingSession.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;CrawlingSessionCB&gt; option = new UpdateOption&lt;CrawlingSessionCB&gt;();
     *     option.self(new SpecifyQuery&lt;CrawlingSessionCB&gt;() {
     *         public void specify(CrawlingSessionCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     crawlingSessionBhv.<span style="color: #FD4747">varyingUpdate</span>(crawlingSession, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param crawlingSession The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(CrawlingSession crawlingSession,
            final UpdateOption<CrawlingSessionCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(crawlingSession,
                new InternalUpdateCallback<CrawlingSession>() {
                    public int callbackDelegateUpdate(CrawlingSession entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * CrawlingSession crawlingSession = new CrawlingSession();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//crawlingSession.setPK...(value);</span>
     * crawlingSession.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//crawlingSession.setVersionNo(value);</span>
     * CrawlingSessionCB cb = new CrawlingSessionCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;CrawlingSessionCB&gt; option = new UpdateOption&lt;CrawlingSessionCB&gt;();
     * option.self(new SpecifyQuery&lt;CrawlingSessionCB&gt;() {
     *     public void specify(CrawlingSessionCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * crawlingSessionBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(crawlingSession, cb, option);
     * </pre>
     * @param crawlingSession The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of CrawlingSession. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(CrawlingSession crawlingSession,
            CrawlingSessionCB cb, final UpdateOption<CrawlingSessionCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(crawlingSession, cb, option);
    }

    protected void processVaryingUpdate(UpdateOption<CrawlingSessionCB> option) {
        assertUpdateOptionNotNull(option);
        CrawlingSessionCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(CrawlingSessionCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends CrawlingSession> void delegateSelectCursor(
            CrawlingSessionCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends CrawlingSession> List<ENTITY> delegateSelectList(
            CrawlingSessionCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(CrawlingSession e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(CrawlingSession e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(CrawlingSession e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<CrawlingSession> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<CrawlingSession> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<CrawlingSession> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(CrawlingSession e, CrawlingSessionCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(CrawlingSessionCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(CrawlingSession e,
            UpdateOption<CrawlingSessionCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(CrawlingSession e,
            CrawlingSessionCB cb, UpdateOption<CrawlingSessionCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected CrawlingSession downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, CrawlingSession.class);
    }

    protected CrawlingSessionCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, CrawlingSessionCB.class);
    }
}
