/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.action.admin;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Locale;

import javax.servlet.http.HttpServletResponse;

import jp.sf.fess.Constants;
import jp.sf.fess.crud.action.admin.BsSearchLogAction;
import jp.sf.fess.crud.util.SAStrutsUtil;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.exception.ActionMessagesException;
import org.seasar.struts.util.RequestUtil;
import org.seasar.struts.util.ResponseUtil;

import com.ibm.icu.text.SimpleDateFormat;

public class SearchLogAction extends BsSearchLogAction {
    private static final Log log = LogFactory.getLog(SearchLogAction.class);

    private static final long serialVersionUID = 1L;

    @Execute(validator = false, input = "error.jsp")
    public String deleteall() {
        searchLogService.deleteAll(searchLogPager);
        SAStrutsUtil.addSessionMessage("success.search_log_delete_all");
        return displayList(true);
    }

    @Execute(validator = false, input = "error.jsp")
    public String download() {
        BufferedWriter writer = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = "FessSearchLog_" + sdf.format(new Date()) + ".csv";
        HttpServletResponse response = ResponseUtil.getResponse();
        response.setContentType("text/csv");
        response.setHeader("Content-disposition", "attachment; filename=\""
                + fileName + "\"");
        try {
            response.setContentType("");
            writer = new BufferedWriter(new OutputStreamWriter(
                    response.getOutputStream(), getCsvEncoding()));
            searchLogService.dump(writer, searchLogPager);
            writer.flush();
        } catch (Exception e) {
            log.error("Could not create FessSearchLog.csv.", e);
            throw new ActionMessagesException(
                    "errors.could_not_create_search_log_csv");
        } finally {
            IOUtils.closeQuietly(writer);
        }
        return null;
    }

    private String getCsvEncoding() {
        if (StringUtil.isNotBlank(searchLogForm.csvEncoding)) {
            return searchLogForm.csvEncoding;
        }
        Locale locale = RequestUtil.getRequest().getLocale();
        if ("ja".equals(locale.getLanguage())) {
            return Constants.MS932;
        }
        return Constants.UTF_8;
    }

    public boolean isHasClickLog() {
        return searchLogForm.clickLogList != null
                && !searchLogForm.clickLogList.isEmpty();
    }
}
