/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.allcommon.CDef;
import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.exentity.PathMapping;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of PATH_MAPPING. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class PathMappingDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final PathMappingDbm _instance = new PathMappingDbm();

    private PathMappingDbm() {
    }

    public static PathMappingDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    public DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    protected final String _tableDbName = "PATH_MAPPING";

    protected final String _tablePropertyName = "pathMapping";

    protected final TableSqlName _tableSqlName = new TableSqlName(
            "PATH_MAPPING");

    public String getTableDbName() {
        return _tableDbName;
    }

    public String getTablePropertyName() {
        return _tablePropertyName;
    }

    public TableSqlName getTableSqlName() {
        return _tableSqlName;
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected final ColumnInfo _columnId = cci("ID", "ID", null, true, "id",
            Long.class, true, true, "BIGINT", 19, 0, false, null, null, null,
            null, null);

    protected final ColumnInfo _columnRegex = cci("REGEX", "REGEX", null, true,
            "regex", String.class, false, false, "VARCHAR", 1000, 0, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnReplacement = cci("REPLACEMENT",
            "REPLACEMENT", null, true, "replacement", String.class, false,
            false, "VARCHAR", 1000, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnProcessType = cci("PROCESS_TYPE",
            "PROCESS_TYPE", null, true, "processType", String.class, false,
            false, "VARCHAR", 1, 0, false, null, null, null, null,
            CDef.DefMeta.ProcessType);

    protected final ColumnInfo _columnSortOrder = cci("SORT_ORDER",
            "SORT_ORDER", null, true, "sortOrder", Integer.class, false, false,
            "INTEGER", 10, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnCreatedBy = cci("CREATED_BY",
            "CREATED_BY", null, true, "createdBy", String.class, false, false,
            "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnCreatedTime = cci("CREATED_TIME",
            "CREATED_TIME", null, true, "createdTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnUpdatedBy = cci("UPDATED_BY",
            "UPDATED_BY", null, false, "updatedBy", String.class, false, false,
            "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnUpdatedTime = cci("UPDATED_TIME",
            "UPDATED_TIME", null, false, "updatedTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnDeletedBy = cci("DELETED_BY",
            "DELETED_BY", null, false, "deletedBy", String.class, false, false,
            "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnDeletedTime = cci("DELETED_TIME",
            "DELETED_TIME", null, false, "deletedTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnVersionNo = cci("VERSION_NO",
            "VERSION_NO", null, true, "versionNo", Integer.class, false, false,
            "INTEGER", 10, 0, false, OptimisticLockType.VERSION_NO, null, null,
            null, null);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnRegex() {
        return _columnRegex;
    }

    public ColumnInfo columnReplacement() {
        return _columnReplacement;
    }

    public ColumnInfo columnProcessType() {
        return _columnProcessType;
    }

    public ColumnInfo columnSortOrder() {
        return _columnSortOrder;
    }

    public ColumnInfo columnCreatedBy() {
        return _columnCreatedBy;
    }

    public ColumnInfo columnCreatedTime() {
        return _columnCreatedTime;
    }

    public ColumnInfo columnUpdatedBy() {
        return _columnUpdatedBy;
    }

    public ColumnInfo columnUpdatedTime() {
        return _columnUpdatedTime;
    }

    public ColumnInfo columnDeletedBy() {
        return _columnDeletedBy;
    }

    public ColumnInfo columnDeletedTime() {
        return _columnDeletedTime;
    }

    public ColumnInfo columnVersionNo() {
        return _columnVersionNo;
    }

    protected List<ColumnInfo> ccil() {
        List<ColumnInfo> ls = newArrayList();
        ls.add(columnId());
        ls.add(columnRegex());
        ls.add(columnReplacement());
        ls.add(columnProcessType());
        ls.add(columnSortOrder());
        ls.add(columnCreatedBy());
        ls.add(columnCreatedTime());
        ls.add(columnUpdatedBy());
        ls.add(columnUpdatedTime());
        ls.add(columnDeletedBy());
        ls.add(columnDeletedTime());
        ls.add(columnVersionNo());
        return ls;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    public boolean hasPrimaryKey() {
        return true;
    }

    public boolean hasTwoOrMorePrimaryKeys() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    public boolean hasIdentity() {
        return true;
    }

    public boolean hasVersionNo() {
        return true;
    }

    public ColumnInfo getVersionNoColumnInfo() {
        return _columnVersionNo;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.PathMapping";
    }

    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.PathMappingCB";
    }

    public String getDaoTypeName() {
        return "jp.sf.fess.db.exdao.PathMappingDao";
    }

    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.PathMappingBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    public Class<PathMapping> getEntityType() {
        return PathMapping.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    public Entity newEntity() {
        return newMyEntity();
    }

    public PathMapping newMyEntity() {
        return new PathMapping();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    public void acceptPrimaryKeyMap(Entity e, Map<String, ? extends Object> m) {
        doAcceptPrimaryKeyMap((PathMapping) e, m, _epsMap);
    }

    public Map<String, Object> extractPrimaryKeyMap(Entity e) {
        return doExtractPrimaryKeyMap(e);
    }

    public Map<String, Object> extractAllColumnMap(Entity e) {
        return doExtractAllColumnMap(e);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<PathMapping>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsRegex(), columnRegex());
        setupEps(_epsMap, new EpsReplacement(), columnReplacement());
        setupEps(_epsMap, new EpsProcessType(), columnProcessType());
        setupEps(_epsMap, new EpsSortOrder(), columnSortOrder());
        setupEps(_epsMap, new EpsCreatedBy(), columnCreatedBy());
        setupEps(_epsMap, new EpsCreatedTime(), columnCreatedTime());
        setupEps(_epsMap, new EpsUpdatedBy(), columnUpdatedBy());
        setupEps(_epsMap, new EpsUpdatedTime(), columnUpdatedTime());
        setupEps(_epsMap, new EpsDeletedBy(), columnDeletedBy());
        setupEps(_epsMap, new EpsDeletedTime(), columnDeletedTime());
        setupEps(_epsMap, new EpsVersionNo(), columnVersionNo());
    }

    public boolean hasEntityPropertySetupper(String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    public void setupEntityProperty(String propertyName, Object entity,
            Object value) {
        findEps(_epsMap, propertyName).setup((PathMapping) entity, value);
    }

    public class EpsId implements Eps<PathMapping> {
        public void setup(PathMapping e, Object v) {
            e.setId(ctl(v));
        }
    }

    public static class EpsRegex implements Eps<PathMapping> {
        public void setup(PathMapping e, Object v) {
            e.setRegex((String) v);
        }
    }

    public static class EpsReplacement implements Eps<PathMapping> {
        public void setup(PathMapping e, Object v) {
            e.setReplacement((String) v);
        }
    }

    public static class EpsProcessType implements Eps<PathMapping> {
        public void setup(PathMapping e, Object v) {
            e.setProcessType((String) v);
        }
    }

    public class EpsSortOrder implements Eps<PathMapping> {
        public void setup(PathMapping e, Object v) {
            e.setSortOrder(cti(v));
        }
    }

    public static class EpsCreatedBy implements Eps<PathMapping> {
        public void setup(PathMapping e, Object v) {
            e.setCreatedBy((String) v);
        }
    }

    public static class EpsCreatedTime implements Eps<PathMapping> {
        public void setup(PathMapping e, Object v) {
            e.setCreatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsUpdatedBy implements Eps<PathMapping> {
        public void setup(PathMapping e, Object v) {
            e.setUpdatedBy((String) v);
        }
    }

    public static class EpsUpdatedTime implements Eps<PathMapping> {
        public void setup(PathMapping e, Object v) {
            e.setUpdatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsDeletedBy implements Eps<PathMapping> {
        public void setup(PathMapping e, Object v) {
            e.setDeletedBy((String) v);
        }
    }

    public static class EpsDeletedTime implements Eps<PathMapping> {
        public void setup(PathMapping e, Object v) {
            e.setDeletedTime((java.sql.Timestamp) v);
        }
    }

    public class EpsVersionNo implements Eps<PathMapping> {
        public void setup(PathMapping e, Object v) {
            e.setVersionNo(cti(v));
        }
    }
}
