<tiles:insert template="/WEB-INF/view/common/admin/layout.jsp" flush="true">
	<tiles:put name="title"><bean:message key="labels.crawling_session_configuration" /></tiles:put>
	<tiles:put name="header" value="/WEB-INF/view/common/admin/header.jsp" />
	<tiles:put name="footer" value="/WEB-INF/view/common/admin/footer.jsp" />
	<tiles:put name="menu" value="/WEB-INF/view/common/admin/menu.jsp" />
	<tiles:put name="menuType" value="crawlingSession" />
	<tiles:put name="headerScript" type="string"></tiles:put>
	<tiles:put name="body" type="string">

      <div id="main">

<!-- Message: BEGIN -->
<div><html:messages id="msg" message="true"><bean:write name="msg" ignore="true"/></html:messages><html:errors/></div>
<!-- Message: END -->

<!-- Search: BEGIN -->
<div class="form-table">
<s:form>
<table>
	<tbody>
		<tr>
			<td>
				<table><tbody>


								<tr>
						<th><bean:message key="labels.crawling_session_session_id_search"/></th>
						<td><html:text property="searchParams.sessionId"></html:text></td>
					</tr>
									     

				</tbody></table>
			</td>
			<td>
				<input type="submit" name="search" value="<bean:message key="labels.crawling_session_search"/>"/>
				<input type="submit" name="reset" value="<bean:message key="labels.crawling_session_reset"/>"/>
			</td>
		</tr>
	</tbody>
</table>
</s:form>
</div>
<!-- Search: END -->

<div style="margin-top:5px;">
<script><!-- 
function confirmToDeleteAll() {
	if(confirm('<bean:message key="labels.crawling_session_delete_all_confirmation"/>')){
		return true;
	} else {
		return false;
	}
}
// -->
</script>
<s:link href="deleteall" onclick="return confirmToDeleteAll();"><bean:message key="labels.crawling_session_delete_all_link"/></s:link>
</div>


<!-- List: BEGIN -->
<div class="list-table" style="margin-top:5px;">
<table border="1">
	<thead>
		<tr>


				<th style="text-align: center;"><bean:message key="labels.crawling_session_session_id"/></th>
				<th style="text-align: center;"><bean:message key="labels.crawling_session_created_time"/></th>
	     
			<th style="text-align: center;">&nbsp;</th>
		</tr>
	</thead>
	<tbody>
		<c:forEach var="data" varStatus="s" items="${crawlingSessionItems}">
		<tr class="${s.index % 2 == 0 ? 'row1' : 'row2'}">



								<td>${f:h(data.sessionId)}</td>
								<td>${f:h(data.createdTime)}</td>
			     

			<td align="center">

				<s:link href="confirmpage/4/${f:u(data.id)}"><bean:message key="labels.crawling_session_link_details"/></s:link>
				<s:link href="deletepage/3/${f:u(data.id)}"><bean:message key="labels.crawling_session_link_delete"/></s:link>
     
			</td>
		</tr>
		</c:forEach>
	</tbody>
</table>
<!-- Page Navigation: BEGIN -->
<div>
	<span>
		<c:if test="${crawlingSessionPager.existPrePage}">
		<s:link href="list/${crawlingSessionPager.currentPageNumber - 1}"><bean:message key="labels.crawling_session_prev_page"/></s:link>
		</c:if>
	</span>
	<span>
		<c:forEach var="p" varStatus="s" items="${crawlingSessionPager.pageNumberList}">
		<span>
			<c:if test="${p == crawlingSessionPager.currentPageNumber}">
			${p}
			</c:if>
			<c:if test="${p != crawlingSessionPager.currentPageNumber}">
			<s:link href="list/${p}">${p}</s:link>
			</c:if>
		</span>
		</c:forEach>
	</span>
	<span>
		<c:if test="${crawlingSessionPager.existNextPage}">
		<s:link href="list/${crawlingSessionPager.currentPageNumber + 1}"><bean:message key="labels.crawling_session_next_page"/></s:link>
		</c:if>
	</span>
</div>
<div>
	<span>
		${crawlingSessionPager.currentPageNumber}/${crawlingSessionPager.allPageCount} (${crawlingSessionPager.allRecordCount})
	</span>
</div>
<!-- Page Navigation: END -->
</div>
<!-- List: END -->

      </div>

	</tiles:put>
</tiles:insert>

