/*
 * Copyright 2009-2012 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.allcommon.CDef;
import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.exentity.SearchLog;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.ReferrerInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of SEARCH_LOG. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class SearchLogDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final SearchLogDbm _instance = new SearchLogDbm();

    private SearchLogDbm() {
    }

    public static SearchLogDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    public DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    protected final String _tableDbName = "SEARCH_LOG";

    protected final String _tablePropertyName = "searchLog";

    protected final TableSqlName _tableSqlName = new TableSqlName("SEARCH_LOG",
            _tableDbName);
    {
        _tableSqlName.xacceptFilter(DBFluteConfig.getInstance()
                .getTableSqlNameFilter());
    }

    @Override
    public String getTableDbName() {
        return _tableDbName;
    }

    @Override
    public String getTablePropertyName() {
        return _tablePropertyName;
    }

    @Override
    public TableSqlName getTableSqlName() {
        return _tableSqlName;
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected final ColumnInfo _columnId = cci("ID", "ID", null, null, true,
            "id", Long.class, true, true, "BIGINT", 19, 0, false, null, null,
            null, "clickLogList,searchFieldLogList", null);

    protected final ColumnInfo _columnSearchWord = cci("SEARCH_WORD",
            "SEARCH_WORD", null, null, false, "searchWord", String.class,
            false, false, "VARCHAR", 1000, 0, false, null, null, null, null,
            null);

    protected final ColumnInfo _columnRequestedTime = cci("REQUESTED_TIME",
            "REQUESTED_TIME", null, null, true, "requestedTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnResponseTime = cci("RESPONSE_TIME",
            "RESPONSE_TIME", null, null, true, "responseTime", Integer.class,
            false, false, "INTEGER", 10, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnHitCount = cci("HIT_COUNT", "HIT_COUNT",
            null, null, true, "hitCount", Long.class, false, false, "BIGINT",
            19, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnQueryOffset = cci("QUERY_OFFSET",
            "QUERY_OFFSET", null, null, true, "queryOffset", Integer.class,
            false, false, "INTEGER", 10, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnQueryPageSize = cci("QUERY_PAGE_SIZE",
            "QUERY_PAGE_SIZE", null, null, true, "queryPageSize",
            Integer.class, false, false, "INTEGER", 10, 0, false, null, null,
            null, null, null);

    protected final ColumnInfo _columnUserAgent = cci("USER_AGENT",
            "USER_AGENT", null, null, false, "userAgent", String.class, false,
            false, "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnReferer = cci("REFERER", "REFERER", null,
            null, false, "referer", String.class, false, false, "VARCHAR",
            1000, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnClientIp = cci("CLIENT_IP", "CLIENT_IP",
            null, null, false, "clientIp", String.class, false, false,
            "VARCHAR", 50, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnUserSessionId = cci("USER_SESSION_ID",
            "USER_SESSION_ID", null, null, false, "userSessionId",
            String.class, false, false, "VARCHAR", 100, 0, false, null, null,
            null, null, null);

    protected final ColumnInfo _columnAccessType = cci("ACCESS_TYPE",
            "ACCESS_TYPE", null, null, true, "accessType", String.class, false,
            false, "VARCHAR", 1, 0, false, null, null, null, null,
            CDef.DefMeta.AccessType);

    protected final ColumnInfo _columnUserId = cci("USER_ID", "USER_ID", null,
            null, false, "userId", Long.class, false, false, "BIGINT", 19, 0,
            false, null, null, "userInfo", null, null);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnSearchWord() {
        return _columnSearchWord;
    }

    public ColumnInfo columnRequestedTime() {
        return _columnRequestedTime;
    }

    public ColumnInfo columnResponseTime() {
        return _columnResponseTime;
    }

    public ColumnInfo columnHitCount() {
        return _columnHitCount;
    }

    public ColumnInfo columnQueryOffset() {
        return _columnQueryOffset;
    }

    public ColumnInfo columnQueryPageSize() {
        return _columnQueryPageSize;
    }

    public ColumnInfo columnUserAgent() {
        return _columnUserAgent;
    }

    public ColumnInfo columnReferer() {
        return _columnReferer;
    }

    public ColumnInfo columnClientIp() {
        return _columnClientIp;
    }

    public ColumnInfo columnUserSessionId() {
        return _columnUserSessionId;
    }

    public ColumnInfo columnAccessType() {
        return _columnAccessType;
    }

    public ColumnInfo columnUserId() {
        return _columnUserId;
    }

    @Override
    protected List<ColumnInfo> ccil() {
        final List<ColumnInfo> ls = newArrayList();
        ls.add(columnId());
        ls.add(columnSearchWord());
        ls.add(columnRequestedTime());
        ls.add(columnResponseTime());
        ls.add(columnHitCount());
        ls.add(columnQueryOffset());
        ls.add(columnQueryPageSize());
        ls.add(columnUserAgent());
        ls.add(columnReferer());
        ls.add(columnClientIp());
        ls.add(columnUserSessionId());
        ls.add(columnAccessType());
        ls.add(columnUserId());
        return ls;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    @Override
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    @Override
    public boolean hasPrimaryKey() {
        return true;
    }

    @Override
    public boolean hasCompoundPrimaryKey() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------
    public ForeignInfo foreignUserInfo() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(
                columnUserId(), UserInfoDbm.getInstance().columnId());
        return cfi("userInfo", this, UserInfoDbm.getInstance(), map, 0, false,
                false, false, "searchLogList");
    }

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------
    public ReferrerInfo referrerClickLogList() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                ClickLogDbm.getInstance().columnSearchId());
        return cri("clickLogList", this, ClickLogDbm.getInstance(), map, false,
                "searchLog");
    }

    public ReferrerInfo referrerSearchFieldLogList() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnId(),
                SearchFieldLogDbm.getInstance().columnSearchId());
        return cri("searchFieldLogList", this, SearchFieldLogDbm.getInstance(),
                map, false, "searchLog");
    }

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    @Override
    public boolean hasIdentity() {
        return true;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    @Override
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.SearchLog";
    }

    @Override
    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.SearchLogCB";
    }

    @Override
    public String getDaoTypeName() {
        return "${glPackageExtendedDao}.SearchLogDao";
    }

    @Override
    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.SearchLogBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    @Override
    public Class<SearchLog> getEntityType() {
        return SearchLog.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    @Override
    public Entity newEntity() {
        return newMyEntity();
    }

    public SearchLog newMyEntity() {
        return new SearchLog();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    @Override
    public void acceptPrimaryKeyMap(final Entity e,
            final Map<String, ? extends Object> m) {
        doAcceptPrimaryKeyMap((SearchLog) e, m, _epsMap);
    }

    @Override
    public void acceptAllColumnMap(final Entity e,
            final Map<String, ? extends Object> m) {
        doAcceptAllColumnMap((SearchLog) e, m, _epsMap);
    }

    @Override
    public Map<String, Object> extractPrimaryKeyMap(final Entity e) {
        return doExtractPrimaryKeyMap(e);
    }

    @Override
    public Map<String, Object> extractAllColumnMap(final Entity e) {
        return doExtractAllColumnMap(e);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<SearchLog>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsSearchWord(), columnSearchWord());
        setupEps(_epsMap, new EpsRequestedTime(), columnRequestedTime());
        setupEps(_epsMap, new EpsResponseTime(), columnResponseTime());
        setupEps(_epsMap, new EpsHitCount(), columnHitCount());
        setupEps(_epsMap, new EpsQueryOffset(), columnQueryOffset());
        setupEps(_epsMap, new EpsQueryPageSize(), columnQueryPageSize());
        setupEps(_epsMap, new EpsUserAgent(), columnUserAgent());
        setupEps(_epsMap, new EpsReferer(), columnReferer());
        setupEps(_epsMap, new EpsClientIp(), columnClientIp());
        setupEps(_epsMap, new EpsUserSessionId(), columnUserSessionId());
        setupEps(_epsMap, new EpsAccessType(), columnAccessType());
        setupEps(_epsMap, new EpsUserId(), columnUserId());
    }

    @Override
    public boolean hasEntityPropertySetupper(final String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    @Override
    public void setupEntityProperty(final String propertyName,
            final Object entity, final Object value) {
        findEps(_epsMap, propertyName).setup((SearchLog) entity, value);
    }

    public class EpsId implements Eps<SearchLog> {
        @Override
        public void setup(final SearchLog e, final Object v) {
            e.setId(ctl(v));
        }
    }

    public static class EpsSearchWord implements Eps<SearchLog> {
        @Override
        public void setup(final SearchLog e, final Object v) {
            e.setSearchWord((String) v);
        }
    }

    public static class EpsRequestedTime implements Eps<SearchLog> {
        @Override
        public void setup(final SearchLog e, final Object v) {
            e.setRequestedTime((java.sql.Timestamp) v);
        }
    }

    public class EpsResponseTime implements Eps<SearchLog> {
        @Override
        public void setup(final SearchLog e, final Object v) {
            e.setResponseTime(cti(v));
        }
    }

    public class EpsHitCount implements Eps<SearchLog> {
        @Override
        public void setup(final SearchLog e, final Object v) {
            e.setHitCount(ctl(v));
        }
    }

    public class EpsQueryOffset implements Eps<SearchLog> {
        @Override
        public void setup(final SearchLog e, final Object v) {
            e.setQueryOffset(cti(v));
        }
    }

    public class EpsQueryPageSize implements Eps<SearchLog> {
        @Override
        public void setup(final SearchLog e, final Object v) {
            e.setQueryPageSize(cti(v));
        }
    }

    public static class EpsUserAgent implements Eps<SearchLog> {
        @Override
        public void setup(final SearchLog e, final Object v) {
            e.setUserAgent((String) v);
        }
    }

    public static class EpsReferer implements Eps<SearchLog> {
        @Override
        public void setup(final SearchLog e, final Object v) {
            e.setReferer((String) v);
        }
    }

    public static class EpsClientIp implements Eps<SearchLog> {
        @Override
        public void setup(final SearchLog e, final Object v) {
            e.setClientIp((String) v);
        }
    }

    public static class EpsUserSessionId implements Eps<SearchLog> {
        @Override
        public void setup(final SearchLog e, final Object v) {
            e.setUserSessionId((String) v);
        }
    }

    public static class EpsAccessType implements Eps<SearchLog> {
        @Override
        public void setup(final SearchLog e, final Object v) {
            e.setAccessType((String) v);
        }
    }

    public class EpsUserId implements Eps<SearchLog> {
        @Override
        public void setup(final SearchLog e, final Object v) {
            e.setUserId(ctl(v));
        }
    }
}
