/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.allcommon;

import java.util.HashMap;
import java.util.Map;

import org.seasar.dbflute.jdbc.Classification;
import org.seasar.dbflute.jdbc.ClassificationCodeType;
import org.seasar.dbflute.jdbc.ClassificationMeta;

/**
 * The definition of classification.
 * @author DBFlute(AutoGenerator)
 */
public interface CDef extends Classification {

    public enum DefMeta implements ClassificationMeta {
        /** Processing Type */
        ProcessType,
        /** Access Type */
        AccessType;
        public Classification codeOf(Object code) {
            if ("ProcessType".equals(name())) {
                return CDef.ProcessType.codeOf(code);
            }
            if ("AccessType".equals(name())) {
                return CDef.AccessType.codeOf(code);
            }
            throw new IllegalStateException("Unknown definition: " + this); // basically unreachable
        }

        public ClassificationCodeType codeType() {
            return ClassificationCodeType.String; // as default
        }
    }

    /**
     * Processing Type
     */
    public enum ProcessType implements CDef {
        /** Crawling: Process When Crawling */
        Crawling("C", "Crawling"),
        /** Displaying: Process When Displaying */
        Displaying("D", "Displaying"),
        /** Both: Process When Crawling/Displaying */
        Both("B", "Both");
        private static final Map<String, ProcessType> _codeValueMap = new HashMap<String, ProcessType>();
        static {
            for (ProcessType value : values()) {
                _codeValueMap.put(value.code().toLowerCase(), value);
            }
        }

        private String _code;

        private String _alias;

        private ProcessType(String code, String alias) {
            _code = code;
            _alias = alias;
        }

        public String code() {
            return _code;
        }

        public String alias() {
            return _alias;
        }

        public ClassificationMeta meta() {
            return CDef.DefMeta.ProcessType;
        }

        public static ProcessType codeOf(Object code) {
            if (code == null) {
                return null;
            }
            if (code instanceof ProcessType) {
                return (ProcessType) code;
            }
            return _codeValueMap.get(code.toString().toLowerCase());
        }

        @Override
        public String toString() {
            return code();
        }
    }

    /**
     * Access Type
     */
    public enum AccessType implements CDef {
        /** Web: Web */
        Web("W", "Web"),
        /** Mobile: Mobile */
        Mobile("M", "Mobile"),
        /** Xml: Xml */
        Xml("X", "Xml"),
        /** Json: Json */
        Json("J", "Json");
        private static final Map<String, AccessType> _codeValueMap = new HashMap<String, AccessType>();
        static {
            for (AccessType value : values()) {
                _codeValueMap.put(value.code().toLowerCase(), value);
            }
        }

        private String _code;

        private String _alias;

        private AccessType(String code, String alias) {
            _code = code;
            _alias = alias;
        }

        public String code() {
            return _code;
        }

        public String alias() {
            return _alias;
        }

        public ClassificationMeta meta() {
            return CDef.DefMeta.AccessType;
        }

        public static AccessType codeOf(Object code) {
            if (code == null) {
                return null;
            }
            if (code instanceof AccessType) {
                return (AccessType) code;
            }
            return _codeValueMap.get(code.toString().toLowerCase());
        }

        @Override
        public String toString() {
            return code();
        }
    }

}
