/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.exentity.FileConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToRoleTypeMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The entity of FILE_CRAWLING_CONFIG that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, PATHS, INCLUDED_PATHS, EXCLUDED_PATHS, INCLUDED_DOC_PATHS, EXCLUDED_DOC_PATHS, DEPTH, MAX_ACCESS_COUNT, NUM_OF_THREAD, INTERVAL_TIME, BOOST, AVAILABLE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     FILE_CONFIG_TO_BROWSER_TYPE_MAPPING, FILE_CONFIG_TO_LABEL_TYPE_MAPPING, FILE_CONFIG_TO_ROLE_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     fileConfigToBrowserTypeMappingList, fileConfigToLabelTypeMappingList, fileConfigToRoleTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsFileCrawlingConfig implements Entity, Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    // -----------------------------------------------------
    //                                                Column
    //                                                ------
    /** ID: {PK : ID : NotNull : BIGINT} */
    protected Long _id;

    /** NAME: {NotNull : VARCHAR(200)} */
    protected String _name;

    /** PATHS: {NotNull : VARCHAR(4000)} */
    protected String _paths;

    /** INCLUDED_PATHS: {VARCHAR(4000)} */
    protected String _includedPaths;

    /** EXCLUDED_PATHS: {VARCHAR(4000)} */
    protected String _excludedPaths;

    /** INCLUDED_DOC_PATHS: {VARCHAR(4000)} */
    protected String _includedDocPaths;

    /** EXCLUDED_DOC_PATHS: {VARCHAR(4000)} */
    protected String _excludedDocPaths;

    /** DEPTH: {INTEGER} */
    protected Integer _depth;

    /** MAX_ACCESS_COUNT: {BIGINT} */
    protected Long _maxAccessCount;

    /** NUM_OF_THREAD: {NotNull : INTEGER} */
    protected Integer _numOfThread;

    /** INTERVAL_TIME: {NotNull : INTEGER} */
    protected Integer _intervalTime;

    /** BOOST: {NotNull : DOUBLE} */
    protected java.math.BigDecimal _boost;

    /** AVAILABLE: {NotNull : VARCHAR(1)} */
    protected String _available;

    /** SORT_ORDER: {NotNull : INTEGER} */
    protected Integer _sortOrder;

    /** CREATED_BY: {NotNull : VARCHAR(255)} */
    protected String _createdBy;

    /** CREATED_TIME: {NotNull : TIMESTAMP} */
    protected java.sql.Timestamp _createdTime;

    /** UPDATED_BY: {VARCHAR(255)} */
    protected String _updatedBy;

    /** UPDATED_TIME: {TIMESTAMP} */
    protected java.sql.Timestamp _updatedTime;

    /** DELETED_BY: {VARCHAR(255)} */
    protected String _deletedBy;

    /** DELETED_TIME: {TIMESTAMP} */
    protected java.sql.Timestamp _deletedTime;

    /** VERSION_NO: {NotNull : INTEGER} */
    protected Integer _versionNo;

    // -----------------------------------------------------
    //                                              Internal
    //                                              --------
    /** The attribute of entity modified properties. (for S2Dao) */
    protected EntityModifiedProperties _modifiedProperties = newEntityModifiedProperties();

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "FILE_CRAWLING_CONFIG";
    }

    public String getTablePropertyName() { // as JavaBeansRule
        return "fileCrawlingConfig";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    public DBMeta getDBMeta() {
        return DBMetaInstanceHandler.findDBMeta(getTableDbName());
    }

    // ===================================================================================
    //                                                          Classification Classifying
    //                                                          ==========================
    // ===================================================================================
    //                                                        Classification Determination
    //                                                        ============================
    // ===================================================================================
    //                                                           Classification Name/Alias
    //                                                           =========================
    // ===================================================================================
    //                                                                    Foreign Property
    //                                                                    ================
    // ===================================================================================
    //                                                                   Referrer Property
    //                                                                   =================
    /** FILE_CONFIG_TO_BROWSER_TYPE_MAPPING as 'fileConfigToBrowserTypeMappingList'. */
    protected List<FileConfigToBrowserTypeMapping> _childrenFileConfigToBrowserTypeMappingList;

    /**
     * FILE_CONFIG_TO_BROWSER_TYPE_MAPPING as 'fileConfigToBrowserTypeMappingList'. {without lazy-load} <br />
     * @return The entity list of referrer property 'fileConfigToBrowserTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FileConfigToBrowserTypeMapping> getFileConfigToBrowserTypeMappingList() {
        if (_childrenFileConfigToBrowserTypeMappingList == null) {
            _childrenFileConfigToBrowserTypeMappingList = new ArrayList<FileConfigToBrowserTypeMapping>();
        }
        return _childrenFileConfigToBrowserTypeMappingList;
    }

    /**
     * FILE_CONFIG_TO_BROWSER_TYPE_MAPPING as 'fileConfigToBrowserTypeMappingList'.
     * @param fileConfigToBrowserTypeMappingList The entity list of referrer property 'fileConfigToBrowserTypeMappingList'. (Nullable)
     */
    public void setFileConfigToBrowserTypeMappingList(
            List<FileConfigToBrowserTypeMapping> fileConfigToBrowserTypeMappingList) {
        _childrenFileConfigToBrowserTypeMappingList = fileConfigToBrowserTypeMappingList;
    }

    /** FILE_CONFIG_TO_LABEL_TYPE_MAPPING as 'fileConfigToLabelTypeMappingList'. */
    protected List<FileConfigToLabelTypeMapping> _childrenFileConfigToLabelTypeMappingList;

    /**
     * FILE_CONFIG_TO_LABEL_TYPE_MAPPING as 'fileConfigToLabelTypeMappingList'. {without lazy-load} <br />
     * @return The entity list of referrer property 'fileConfigToLabelTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FileConfigToLabelTypeMapping> getFileConfigToLabelTypeMappingList() {
        if (_childrenFileConfigToLabelTypeMappingList == null) {
            _childrenFileConfigToLabelTypeMappingList = new ArrayList<FileConfigToLabelTypeMapping>();
        }
        return _childrenFileConfigToLabelTypeMappingList;
    }

    /**
     * FILE_CONFIG_TO_LABEL_TYPE_MAPPING as 'fileConfigToLabelTypeMappingList'.
     * @param fileConfigToLabelTypeMappingList The entity list of referrer property 'fileConfigToLabelTypeMappingList'. (Nullable)
     */
    public void setFileConfigToLabelTypeMappingList(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList) {
        _childrenFileConfigToLabelTypeMappingList = fileConfigToLabelTypeMappingList;
    }

    /** FILE_CONFIG_TO_ROLE_TYPE_MAPPING as 'fileConfigToRoleTypeMappingList'. */
    protected List<FileConfigToRoleTypeMapping> _childrenFileConfigToRoleTypeMappingList;

    /**
     * FILE_CONFIG_TO_ROLE_TYPE_MAPPING as 'fileConfigToRoleTypeMappingList'. {without lazy-load} <br />
     * @return The entity list of referrer property 'fileConfigToRoleTypeMappingList'. (NotNull: If it's not loaded yet, initializes the list instance of referrer as empty and returns it.)
     */
    public List<FileConfigToRoleTypeMapping> getFileConfigToRoleTypeMappingList() {
        if (_childrenFileConfigToRoleTypeMappingList == null) {
            _childrenFileConfigToRoleTypeMappingList = new ArrayList<FileConfigToRoleTypeMapping>();
        }
        return _childrenFileConfigToRoleTypeMappingList;
    }

    /**
     * FILE_CONFIG_TO_ROLE_TYPE_MAPPING as 'fileConfigToRoleTypeMappingList'.
     * @param fileConfigToRoleTypeMappingList The entity list of referrer property 'fileConfigToRoleTypeMappingList'. (Nullable)
     */
    public void setFileConfigToRoleTypeMappingList(
            List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList) {
        _childrenFileConfigToRoleTypeMappingList = fileConfigToRoleTypeMappingList;
    }

    // ===================================================================================
    //                                                                       Determination
    //                                                                       =============
    public boolean hasPrimaryKeyValue() {
        if (_id == null) {
            return false;
        }
        return true;
    }

    // ===================================================================================
    //                                                                 Modified Properties
    //                                                                 ===================
    public Set<String> getModifiedPropertyNames() {
        return _modifiedProperties.getPropertyNames();
    }

    protected EntityModifiedProperties newEntityModifiedProperties() {
        return new EntityModifiedProperties();
    }

    public void clearModifiedPropertyNames() {
        _modifiedProperties.clear();
    }

    public boolean hasModification() {
        return !_modifiedProperties.isEmpty();
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * If the primary-key of the other is same as this one, returns true.
     * @param other Other entity.
     * @return Comparing result.
     */
    public boolean equals(Object other) {
        if (other == null || !(other instanceof BsFileCrawlingConfig)) {
            return false;
        }
        BsFileCrawlingConfig otherEntity = (BsFileCrawlingConfig) other;
        if (!helpComparingValue(getId(), otherEntity.getId())) {
            return false;
        }
        return true;
    }

    protected boolean helpComparingValue(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1 != null && value2 != null && value1.equals(value2);
    }

    /**
     * Calculates hash-code from primary-key.
     * @return Hash-code from primary-key.
     */
    public int hashCode() {
        int result = 17;
        if (getId() != null) {
            result = (31 * result) + getId().hashCode();
        }
        return result;
    }

    /**
     * @return The view string of all columns. (NotNull)
     */
    public String toString() {
        String delimiter = ",";
        StringBuilder sb = new StringBuilder();
        sb.append(delimiter).append(getId());
        sb.append(delimiter).append(getName());
        sb.append(delimiter).append(getPaths());
        sb.append(delimiter).append(getIncludedPaths());
        sb.append(delimiter).append(getExcludedPaths());
        sb.append(delimiter).append(getIncludedDocPaths());
        sb.append(delimiter).append(getExcludedDocPaths());
        sb.append(delimiter).append(getDepth());
        sb.append(delimiter).append(getMaxAccessCount());
        sb.append(delimiter).append(getNumOfThread());
        sb.append(delimiter).append(getIntervalTime());
        sb.append(delimiter).append(getBoost());
        sb.append(delimiter).append(getAvailable());
        sb.append(delimiter).append(getSortOrder());
        sb.append(delimiter).append(getCreatedBy());
        sb.append(delimiter).append(getCreatedTime());
        sb.append(delimiter).append(getUpdatedBy());
        sb.append(delimiter).append(getUpdatedTime());
        sb.append(delimiter).append(getDeletedBy());
        sb.append(delimiter).append(getDeletedTime());
        sb.append(delimiter).append(getVersionNo());
        if (sb.length() > 0) {
            sb.delete(0, delimiter.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * ID: {PK : ID : NotNull : BIGINT} <br />
     * @return The value of the column 'ID'. (Nullable)
     */
    public Long getId() {
        return _id;
    }

    /**
     * ID: {PK : ID : NotNull : BIGINT} <br />
     * @param id The value of the column 'ID'. (Nullable)
     */
    public void setId(Long id) {
        _modifiedProperties.addPropertyName("id");
        this._id = id;
    }

    /**
     * NAME: {NotNull : VARCHAR(200)} <br />
     * @return The value of the column 'NAME'. (Nullable)
     */
    public String getName() {
        return _name;
    }

    /**
     * NAME: {NotNull : VARCHAR(200)} <br />
     * @param name The value of the column 'NAME'. (Nullable)
     */
    public void setName(String name) {
        _modifiedProperties.addPropertyName("name");
        this._name = name;
    }

    /**
     * PATHS: {NotNull : VARCHAR(4000)} <br />
     * @return The value of the column 'PATHS'. (Nullable)
     */
    public String getPaths() {
        return _paths;
    }

    /**
     * PATHS: {NotNull : VARCHAR(4000)} <br />
     * @param paths The value of the column 'PATHS'. (Nullable)
     */
    public void setPaths(String paths) {
        _modifiedProperties.addPropertyName("paths");
        this._paths = paths;
    }

    /**
     * INCLUDED_PATHS: {VARCHAR(4000)} <br />
     * @return The value of the column 'INCLUDED_PATHS'. (Nullable)
     */
    public String getIncludedPaths() {
        return _includedPaths;
    }

    /**
     * INCLUDED_PATHS: {VARCHAR(4000)} <br />
     * @param includedPaths The value of the column 'INCLUDED_PATHS'. (Nullable)
     */
    public void setIncludedPaths(String includedPaths) {
        _modifiedProperties.addPropertyName("includedPaths");
        this._includedPaths = includedPaths;
    }

    /**
     * EXCLUDED_PATHS: {VARCHAR(4000)} <br />
     * @return The value of the column 'EXCLUDED_PATHS'. (Nullable)
     */
    public String getExcludedPaths() {
        return _excludedPaths;
    }

    /**
     * EXCLUDED_PATHS: {VARCHAR(4000)} <br />
     * @param excludedPaths The value of the column 'EXCLUDED_PATHS'. (Nullable)
     */
    public void setExcludedPaths(String excludedPaths) {
        _modifiedProperties.addPropertyName("excludedPaths");
        this._excludedPaths = excludedPaths;
    }

    /**
     * INCLUDED_DOC_PATHS: {VARCHAR(4000)} <br />
     * @return The value of the column 'INCLUDED_DOC_PATHS'. (Nullable)
     */
    public String getIncludedDocPaths() {
        return _includedDocPaths;
    }

    /**
     * INCLUDED_DOC_PATHS: {VARCHAR(4000)} <br />
     * @param includedDocPaths The value of the column 'INCLUDED_DOC_PATHS'. (Nullable)
     */
    public void setIncludedDocPaths(String includedDocPaths) {
        _modifiedProperties.addPropertyName("includedDocPaths");
        this._includedDocPaths = includedDocPaths;
    }

    /**
     * EXCLUDED_DOC_PATHS: {VARCHAR(4000)} <br />
     * @return The value of the column 'EXCLUDED_DOC_PATHS'. (Nullable)
     */
    public String getExcludedDocPaths() {
        return _excludedDocPaths;
    }

    /**
     * EXCLUDED_DOC_PATHS: {VARCHAR(4000)} <br />
     * @param excludedDocPaths The value of the column 'EXCLUDED_DOC_PATHS'. (Nullable)
     */
    public void setExcludedDocPaths(String excludedDocPaths) {
        _modifiedProperties.addPropertyName("excludedDocPaths");
        this._excludedDocPaths = excludedDocPaths;
    }

    /**
     * DEPTH: {INTEGER} <br />
     * @return The value of the column 'DEPTH'. (Nullable)
     */
    public Integer getDepth() {
        return _depth;
    }

    /**
     * DEPTH: {INTEGER} <br />
     * @param depth The value of the column 'DEPTH'. (Nullable)
     */
    public void setDepth(Integer depth) {
        _modifiedProperties.addPropertyName("depth");
        this._depth = depth;
    }

    /**
     * MAX_ACCESS_COUNT: {BIGINT} <br />
     * @return The value of the column 'MAX_ACCESS_COUNT'. (Nullable)
     */
    public Long getMaxAccessCount() {
        return _maxAccessCount;
    }

    /**
     * MAX_ACCESS_COUNT: {BIGINT} <br />
     * @param maxAccessCount The value of the column 'MAX_ACCESS_COUNT'. (Nullable)
     */
    public void setMaxAccessCount(Long maxAccessCount) {
        _modifiedProperties.addPropertyName("maxAccessCount");
        this._maxAccessCount = maxAccessCount;
    }

    /**
     * NUM_OF_THREAD: {NotNull : INTEGER} <br />
     * @return The value of the column 'NUM_OF_THREAD'. (Nullable)
     */
    public Integer getNumOfThread() {
        return _numOfThread;
    }

    /**
     * NUM_OF_THREAD: {NotNull : INTEGER} <br />
     * @param numOfThread The value of the column 'NUM_OF_THREAD'. (Nullable)
     */
    public void setNumOfThread(Integer numOfThread) {
        _modifiedProperties.addPropertyName("numOfThread");
        this._numOfThread = numOfThread;
    }

    /**
     * INTERVAL_TIME: {NotNull : INTEGER} <br />
     * @return The value of the column 'INTERVAL_TIME'. (Nullable)
     */
    public Integer getIntervalTime() {
        return _intervalTime;
    }

    /**
     * INTERVAL_TIME: {NotNull : INTEGER} <br />
     * @param intervalTime The value of the column 'INTERVAL_TIME'. (Nullable)
     */
    public void setIntervalTime(Integer intervalTime) {
        _modifiedProperties.addPropertyName("intervalTime");
        this._intervalTime = intervalTime;
    }

    /**
     * BOOST: {NotNull : DOUBLE} <br />
     * @return The value of the column 'BOOST'. (Nullable)
     */
    public java.math.BigDecimal getBoost() {
        return _boost;
    }

    /**
     * BOOST: {NotNull : DOUBLE} <br />
     * @param boost The value of the column 'BOOST'. (Nullable)
     */
    public void setBoost(java.math.BigDecimal boost) {
        _modifiedProperties.addPropertyName("boost");
        this._boost = boost;
    }

    /**
     * AVAILABLE: {NotNull : VARCHAR(1)} <br />
     * @return The value of the column 'AVAILABLE'. (Nullable)
     */
    public String getAvailable() {
        return _available;
    }

    /**
     * AVAILABLE: {NotNull : VARCHAR(1)} <br />
     * @param available The value of the column 'AVAILABLE'. (Nullable)
     */
    public void setAvailable(String available) {
        _modifiedProperties.addPropertyName("available");
        this._available = available;
    }

    /**
     * SORT_ORDER: {NotNull : INTEGER} <br />
     * @return The value of the column 'SORT_ORDER'. (Nullable)
     */
    public Integer getSortOrder() {
        return _sortOrder;
    }

    /**
     * SORT_ORDER: {NotNull : INTEGER} <br />
     * @param sortOrder The value of the column 'SORT_ORDER'. (Nullable)
     */
    public void setSortOrder(Integer sortOrder) {
        _modifiedProperties.addPropertyName("sortOrder");
        this._sortOrder = sortOrder;
    }

    /**
     * CREATED_BY: {NotNull : VARCHAR(255)} <br />
     * @return The value of the column 'CREATED_BY'. (Nullable)
     */
    public String getCreatedBy() {
        return _createdBy;
    }

    /**
     * CREATED_BY: {NotNull : VARCHAR(255)} <br />
     * @param createdBy The value of the column 'CREATED_BY'. (Nullable)
     */
    public void setCreatedBy(String createdBy) {
        _modifiedProperties.addPropertyName("createdBy");
        this._createdBy = createdBy;
    }

    /**
     * CREATED_TIME: {NotNull : TIMESTAMP} <br />
     * @return The value of the column 'CREATED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getCreatedTime() {
        return _createdTime;
    }

    /**
     * CREATED_TIME: {NotNull : TIMESTAMP} <br />
     * @param createdTime The value of the column 'CREATED_TIME'. (Nullable)
     */
    public void setCreatedTime(java.sql.Timestamp createdTime) {
        _modifiedProperties.addPropertyName("createdTime");
        this._createdTime = createdTime;
    }

    /**
     * UPDATED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'UPDATED_BY'. (Nullable)
     */
    public String getUpdatedBy() {
        return _updatedBy;
    }

    /**
     * UPDATED_BY: {VARCHAR(255)} <br />
     * @param updatedBy The value of the column 'UPDATED_BY'. (Nullable)
     */
    public void setUpdatedBy(String updatedBy) {
        _modifiedProperties.addPropertyName("updatedBy");
        this._updatedBy = updatedBy;
    }

    /**
     * UPDATED_TIME: {TIMESTAMP} <br />
     * @return The value of the column 'UPDATED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getUpdatedTime() {
        return _updatedTime;
    }

    /**
     * UPDATED_TIME: {TIMESTAMP} <br />
     * @param updatedTime The value of the column 'UPDATED_TIME'. (Nullable)
     */
    public void setUpdatedTime(java.sql.Timestamp updatedTime) {
        _modifiedProperties.addPropertyName("updatedTime");
        this._updatedTime = updatedTime;
    }

    /**
     * DELETED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'DELETED_BY'. (Nullable)
     */
    public String getDeletedBy() {
        return _deletedBy;
    }

    /**
     * DELETED_BY: {VARCHAR(255)} <br />
     * @param deletedBy The value of the column 'DELETED_BY'. (Nullable)
     */
    public void setDeletedBy(String deletedBy) {
        _modifiedProperties.addPropertyName("deletedBy");
        this._deletedBy = deletedBy;
    }

    /**
     * DELETED_TIME: {TIMESTAMP} <br />
     * @return The value of the column 'DELETED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getDeletedTime() {
        return _deletedTime;
    }

    /**
     * DELETED_TIME: {TIMESTAMP} <br />
     * @param deletedTime The value of the column 'DELETED_TIME'. (Nullable)
     */
    public void setDeletedTime(java.sql.Timestamp deletedTime) {
        _modifiedProperties.addPropertyName("deletedTime");
        this._deletedTime = deletedTime;
    }

    /**
     * VERSION_NO: {NotNull : INTEGER} <br />
     * @return The value of the column 'VERSION_NO'. (Nullable)
     */
    public Integer getVersionNo() {
        return _versionNo;
    }

    /**
     * VERSION_NO: {NotNull : INTEGER} <br />
     * @param versionNo The value of the column 'VERSION_NO'. (Nullable)
     */
    public void setVersionNo(Integer versionNo) {
        _modifiedProperties.addPropertyName("versionNo");
        this._versionNo = versionNo;
    }
}
